/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.pref;

import android.content.SharedPreferences;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.athena.util.log.ULog;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0086\u0002J\u0016\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000fJ\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u0015H\u0007J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0007J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001a2\u0006\u0010\u0010\u001a\u00020\u0007J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u001cH\u0007J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00072\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0007J\u0018\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0015H\u0002J\u0016\u0010#\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007J\u0016\u0010$\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u000fJ\u0016\u0010%\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0015J!\u0010&\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(\u00a2\u0006\u0002\u0010)J\u001e\u0010*\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001aJ\u0016\u0010+\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u001cJ\u0016\u0010,\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0001J\u0018\u0010.\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0016J\u000e\u0010/\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007R\u001b\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00060"}, d2={"Ltv/athena/util/pref/YSharedPref;", "", "mPref", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "all", "", "", "getAll", "()Ljava/util/Map;", "getMPref", "()Landroid/content/SharedPreferences;", "clear", "", "contain", "", "key", "get", "getBoolean", "defaultValue", "getInt", "", "getIntArray", "", "outValues", "getIntList", "", "getLong", "", "getObj", "className", "Ljava/lang/Class;", "getString", "parseInt", "value", "put", "putBoolean", "putInt", "putIntArray", "values", "", "(Ljava/lang/String;[Ljava/lang/Integer;)V", "putIntList", "putLong", "putObject", "obj", "putString", "remove", "utils_release"})
public abstract class YSharedPref {
    @NotNull
    private final SharedPreferences mPref;

    @NotNull
    public final Map<String, ?> getAll() {
        Map map2 = this.mPref.getAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"mPref.all");
        return map2;
    }

    public void putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.put(key, value);
    }

    @Nullable
    public final String getString(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.get(key);
    }

    @Nullable
    public final String getString(@NotNull String key, @NotNull String defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)defaultValue, (String)"defaultValue");
        return this.mPref.getString(key, defaultValue);
    }

    public final void putInt(@NotNull String key, int value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.put(key, String.valueOf(value));
    }

    public final void putBoolean(@NotNull String key, boolean value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.put(key, String.valueOf(value));
    }

    public final boolean getBoolean(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String rawValue = this.get(key);
        if (TextUtils.isEmpty((CharSequence)rawValue)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(rawValue);
        }
        catch (Exception e) {
            ULog.e("YSharedPref", "failed to parse boolean value for key %s, %s", e, key);
            return defaultValue;
        }
    }

    @JvmOverloads
    public final int getInt(@NotNull String key, int defaultValue) {
        int n;
        String rawValue;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String $receiver = string2 = (rawValue = this.get(key));
        CharSequence charSequence = $receiver;
        if (charSequence == null || charSequence.length() == 0) {
            n = defaultValue;
        } else {
            String string3 = $receiver;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            n = this.parseInt(string3, defaultValue);
        }
        return n;
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ int getInt$default(YSharedPref ySharedPref, String string2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getInt");
        }
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return ySharedPref.getInt(string2, n);
    }

    @JvmOverloads
    public final int getInt(@NotNull String key) {
        return YSharedPref.getInt$default(this, key, 0, 2, null);
    }

    private final int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            ULog.e("YSharedPref", "lcy failed to parse value for key %s, %s", e, value);
            return defaultValue;
        }
    }

    public final void putLong(@NotNull String key, long value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.put(key, String.valueOf(value));
    }

    @JvmOverloads
    public final long getLong(@NotNull String key, long defaultValue) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String rawValue = this.get(key);
        CharSequence charSequence = rawValue;
        if (charSequence == null || charSequence.length() == 0) {
            return defaultValue;
        }
        try {
            String string2 = rawValue;
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            charSequence = string2;
            return Long.parseLong((String)charSequence);
        }
        catch (NumberFormatException e) {
            Throwable throwable = e;
            Object[] objectArray = new Object[2];
            String string3 = rawValue;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            objectArray[0] = string3;
            objectArray[1] = key;
            ULog.e("YSharedPref", "lcy failed to parse %s as long, for key %s", throwable, objectArray);
            return defaultValue;
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ long getLong$default(YSharedPref ySharedPref, String string2, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLong");
        }
        if ((n & 2) != 0) {
            l = -1L;
        }
        return ySharedPref.getLong(string2, l);
    }

    @JvmOverloads
    public final long getLong(@NotNull String key) {
        return YSharedPref.getLong$default(this, key, 0L, 2, null);
    }

    public final void putIntArray(@NotNull String key, @NotNull Integer[] values) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        this.putIntList(key, Arrays.asList(Arrays.copyOf(values, values.length)));
    }

    @JvmOverloads
    @Nullable
    public final int[] getIntArray(@NotNull String key, @Nullable int[] outValues) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        List<Integer> list = this.getIntList(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        int[] ret = outValues != null && list.size() <= outValues.length ? outValues : new int[list.size()];
        int i = 0;
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext()) {
            int e = ((Number)iterator.next()).intValue();
            ret[i++] = e;
        }
        return ret;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ int[] getIntArray$default(YSharedPref ySharedPref, String string2, int[] nArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getIntArray");
        }
        if ((n & 2) != 0) {
            nArray = null;
        }
        return ySharedPref.getIntArray(string2, nArray);
    }

    @JvmOverloads
    @Nullable
    public final int[] getIntArray(@NotNull String key) {
        return YSharedPref.getIntArray$default(this, key, null, 2, null);
    }

    public final void putIntList(@NotNull String key, @Nullable List<Integer> values) {
        String value;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (values == null || values.size() == 0) {
            return;
        }
        String string2 = value = TextUtils.join((CharSequence)",", (Iterable)values);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value");
        this.put(key, string2);
    }

    @Nullable
    public final List<Integer> getIntList(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String val = this.get(key);
        if (TextUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        String[] values = TextUtils.split((String)val, (String)",");
        if (values == null || values.length == 0) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String e : values) {
            try {
                list.add(Integer.parseInt(e));
            }
            catch (NumberFormatException ex) {
                ULog.e("YSharedPref", "lcy failed to parse value for key: %s, value: %s", ex, key, e);
            }
        }
        return list;
    }

    public final void put(@NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.mPref.edit().putString(key, value).apply();
    }

    @Nullable
    public final String get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.mPref.getString(key, null);
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.mPref.edit().remove(key).apply();
    }

    public final void clear() {
        this.mPref.edit().clear().apply();
    }

    public final boolean contain(@Nullable String key) {
        return key == null || key.length() == 0 ? false : this.mPref.contains(key);
    }

    public final void putObject(@NotNull String key, @NotNull Object obj) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
    }

    @Nullable
    public final Object getObj(@NotNull String key, @NotNull Class<?> className) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(className, (String)"className");
        return null;
    }

    @NotNull
    protected final SharedPreferences getMPref() {
        return this.mPref;
    }

    public YSharedPref(@NotNull SharedPreferences mPref) {
        Intrinsics.checkParameterIsNotNull((Object)mPref, (String)"mPref");
        this.mPref = mPref;
    }
}

