/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.support.v4.app.FragmentActivity;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.util.permissions.helper.PermissionHelper;
import tv.athena.util.permissions.overlay.OverlayRequestFactory;
import tv.athena.util.permissions.request.IPermissionRequest;
import tv.athena.util.permissions.request.PermissionRequestFactory;
import tv.athena.util.permissions.setting.ISettingRequest;
import tv.athena.util.permissions.setting.SettingRequest;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\nJ-\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\"\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ/\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\nJ)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J3\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\t\"\u00020\u0005\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u001d"}, d2={"Ltv/athena/util/permissions/PermissionUtil;", "", "()V", "getAlwaysDeniedPermissions", "", "", "activity", "Landroid/app/Activity;", "deniedPermissions", "", "(Landroid/app/Activity;[Ljava/lang/String;)Ljava/util/List;", "getDeniedPermissions", "context", "Landroid/content/Context;", "permissions", "(Landroid/content/Context;[Ljava/lang/String;)Ljava/util/List;", "getRationalePermissions", "hasAlwaysDeniedPermission", "", "(Landroid/app/Activity;[Ljava/lang/String;)Z", "requestOverlayPermission", "Ltv/athena/util/permissions/request/IPermissionRequest;", "", "fragmentActivity", "Landroid/support/v4/app/FragmentActivity;", "requestPermissions", "(Landroid/support/v4/app/FragmentActivity;[Ljava/lang/String;)Ltv/athena/util/permissions/request/IPermissionRequest;", "requestSettingPage", "Ltv/athena/util/permissions/setting/ISettingRequest;", "utils_release"})
public final class PermissionUtil {
    public static final PermissionUtil INSTANCE;

    @NotNull
    public final List<String> getDeniedPermissions(@NotNull Context context, String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        return PermissionHelper.INSTANCE.getDeniedPermissions(context, Arrays.copyOf(permissions, permissions.length));
    }

    @TargetApi(value=23)
    @NotNull
    public final List<String> getRationalePermissions(@NotNull Activity activity, String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        return PermissionHelper.INSTANCE.getRationalePermissions(activity, Arrays.copyOf(permissions, permissions.length));
    }

    @TargetApi(value=23)
    public final boolean hasAlwaysDeniedPermission(@NotNull Activity activity, String ... deniedPermissions) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)deniedPermissions, (String)"deniedPermissions");
        return PermissionHelper.INSTANCE.hasAlwaysDeniedPermission(activity, Arrays.copyOf(deniedPermissions, deniedPermissions.length));
    }

    @TargetApi(value=23)
    @NotNull
    public final List<String> getAlwaysDeniedPermissions(@NotNull Activity activity, String ... deniedPermissions) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)deniedPermissions, (String)"deniedPermissions");
        return PermissionHelper.INSTANCE.getAlwaysDeniedPermissions(activity, Arrays.copyOf(deniedPermissions, deniedPermissions.length));
    }

    @NotNull
    public final IPermissionRequest<List<String>> requestPermissions(@NotNull FragmentActivity fragmentActivity, String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentActivity, (String)"fragmentActivity");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        return PermissionRequestFactory.INSTANCE.createRequestFactory(fragmentActivity, permissions);
    }

    @NotNull
    public final ISettingRequest requestSettingPage(@NotNull FragmentActivity fragmentActivity) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentActivity, (String)"fragmentActivity");
        return new SettingRequest(fragmentActivity);
    }

    @NotNull
    public final IPermissionRequest<Unit> requestOverlayPermission(@NotNull FragmentActivity fragmentActivity) {
        Intrinsics.checkParameterIsNotNull((Object)fragmentActivity, (String)"fragmentActivity");
        return OverlayRequestFactory.INSTANCE.createOverlayRequest(fragmentActivity);
    }

    private PermissionUtil() {
    }

    static {
        PermissionUtil permissionUtil;
        INSTANCE = permissionUtil = new PermissionUtil();
    }
}

