/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public final class PackerNg {
    private static final String TAG = "PackerNg";
    private static final String EMPTY_STRING = "";
    private static String sCachedMarket;
    private static final String USAGE_TEXT = "Usage: java -jar PackerNg-x.x.x.jar apkFile marketFile [outputDir] ";
    private static final String INTRO_TEXT = "\nAttention: if your app using Android gradle plugin 2.2.0 or later, be sure to install one of the generated Apks to device or emulator, to ensure the apk can be installed without errors. More details please go to github https://github.com/mcxiaoke/packer-ng-plugin .\n";

    public static synchronized String getMarket(Object context) {
        if (sCachedMarket == null) {
            sCachedMarket = PackerNg.getMarketInternal((Object)context).market;
        }
        return sCachedMarket;
    }

    public static synchronized MarketInfo getMarketInfo(Object context) {
        return PackerNg.getMarketInternal(context);
    }

    private static MarketInfo getMarketInternal(Object context) {
        Exception error;
        String market;
        try {
            String sourceDir = Helper.getSourceDir(context);
            market = Helper.readMarket(new File(sourceDir));
            error = null;
        }
        catch (Exception e) {
            market = null;
            error = e;
        }
        return new MarketInfo(market, error);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            Helper.println(USAGE_TEXT);
            Helper.println(INTRO_TEXT);
            System.exit(1);
        }
        File apkFile = new File(args[0]);
        File marketFile = new File(args[1]);
        File outputDir = new File(args.length >= 3 ? args[2] : "apks");
        if (!apkFile.exists()) {
            Helper.printErr("Apk file '" + apkFile.getAbsolutePath() + "' is not exists or not readable.");
            Helper.println(USAGE_TEXT);
            System.exit(1);
            return;
        }
        if (!marketFile.exists()) {
            Helper.printErr("Market file '" + marketFile.getAbsolutePath() + "' is not exists or not readable.");
            Helper.println(USAGE_TEXT);
            System.exit(1);
            return;
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        Helper.println("Apk File: " + apkFile.getAbsolutePath());
        Helper.println("Market File: " + marketFile.getAbsolutePath());
        Helper.println("Output Dir: " + outputDir.getAbsolutePath());
        List<String> markets = null;
        try {
            markets = Helper.parseMarkets(marketFile);
        }
        catch (IOException e) {
            Helper.printErr("Market file parse failed.");
            System.exit(1);
        }
        if (markets == null || markets.isEmpty()) {
            Helper.printErr("No markets found.");
            System.exit(1);
            return;
        }
        String baseName = Helper.getBaseName(apkFile.getName());
        String extName = Helper.getExtension(apkFile.getName());
        int processed = 0;
        try {
            for (String market : markets) {
                String apkName = baseName + "-" + market + "." + extName;
                File destFile = new File(outputDir, apkName);
                Helper.copyFile(apkFile, destFile);
                Helper.writeMarket(destFile, market);
                if (Helper.verifyMarket(destFile, market)) {
                    ++processed;
                    Helper.println("Generating apk " + apkName);
                    continue;
                }
                destFile.delete();
                Helper.printErr("Failed to generate " + apkName);
            }
            Helper.println("[Success] All " + processed + " apks saved to " + outputDir.getAbsolutePath());
            Helper.println(INTRO_TEXT);
        }
        catch (MarketExistsException ex) {
            Helper.printErr("Market info exists in '" + apkFile + "', please using a clean apk.");
            System.exit(1);
        }
        catch (IOException ex) {
            Helper.printErr(EMPTY_STRING + ex);
            System.exit(1);
        }
    }

    public static class Helper {
        static final String UTF_8 = "UTF-8";
        static final int ZIP_COMMENT_MAX_LENGTH = 65535;
        static final int SHORT_LENGTH = 2;
        static final byte[] MAGIC = new byte[]{33, 90, 88, 75, 33};

        private static String getSourceDir(Object context) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
            Class<?> contextClass = Class.forName("android.content.Context");
            Class<?> applicationInfoClass = Class.forName("android.content.pm.ApplicationInfo");
            Method getApplicationInfoMethod = contextClass.getMethod("getApplicationInfo", new Class[0]);
            Object appInfo = getApplicationInfoMethod.invoke(context, new Object[0]);
            Field publicSourceDirField = applicationInfoClass.getField("publicSourceDir");
            String sourceDir = (String)publicSourceDirField.get(appInfo);
            if (sourceDir == null) {
                Field sourceDirField = applicationInfoClass.getField("sourceDir");
                sourceDir = (String)sourceDirField.get(appInfo);
            }
            if (sourceDir == null) {
                Method getPackageCodePathMethod = contextClass.getMethod("getPackageCodePath", new Class[0]);
                sourceDir = (String)getPackageCodePathMethod.invoke(context, new Object[0]);
            }
            return sourceDir;
        }

        private static boolean isMagicMatched(byte[] buffer) {
            if (buffer.length != MAGIC.length) {
                return false;
            }
            for (int i = 0; i < MAGIC.length; ++i) {
                if (buffer[i] == MAGIC[i]) continue;
                return false;
            }
            return true;
        }

        private static void writeBytes(byte[] data, DataOutput out) throws IOException {
            out.write(data);
        }

        private static void writeShort(int i, DataOutput out) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            bb.putShort((short)i);
            out.write(bb.array());
        }

        private static short readShort(DataInput input) throws IOException {
            byte[] buf = new byte[2];
            input.readFully(buf);
            ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
            return bb.getShort(0);
        }

        public static void writeZipComment(File file, String comment) throws IOException {
            if (Helper.hasZipCommentMagic(file)) {
                throw new MarketExistsException("Zip comment already exists, ignore.");
            }
            byte[] data = comment.getBytes(UTF_8);
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            raf.seek(file.length() - 2L);
            Helper.writeShort(data.length + 2 + MAGIC.length, raf);
            Helper.writeBytes(data, raf);
            Helper.writeShort(data.length, raf);
            Helper.writeBytes(MAGIC, raf);
            raf.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean hasZipCommentMagic(File file) throws IOException {
            try (RandomAccessFile raf = null;){
                raf = new RandomAccessFile(file, "r");
                long index = raf.length();
                byte[] buffer = new byte[MAGIC.length];
                raf.seek(index -= (long)MAGIC.length);
                raf.readFully(buffer);
                boolean bl = Helper.isMagicMatched(buffer);
                return bl;
            }
        }

        public static String readZipComment(File file) throws IOException {
            try (RandomAccessFile raf = null;){
                raf = new RandomAccessFile(file, "r");
                long index = raf.length();
                byte[] buffer = new byte[MAGIC.length];
                raf.seek(index -= (long)MAGIC.length);
                raf.readFully(buffer);
                if (Helper.isMagicMatched(buffer)) {
                    raf.seek(index -= 2L);
                    short length = Helper.readShort(raf);
                    if (length > 0) {
                        raf.seek(index -= (long)length);
                        byte[] bytesComment = new byte[length];
                        raf.readFully(bytesComment);
                        String string = new String(bytesComment, UTF_8);
                        return string;
                    }
                    throw new MarketNotFoundException("Zip comment content not found");
                }
                throw new MarketNotFoundException("Zip comment magic bytes not found");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String readZipCommentMmp(File file) throws IOException {
            int mappedSize = 10240;
            long fz = file.length();
            RandomAccessFile raf = null;
            MappedByteBuffer map2 = null;
            try {
                raf = new RandomAccessFile(file, "r");
                map2 = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, fz - 10240L, 10240L);
                map2.order(ByteOrder.LITTLE_ENDIAN);
                int index = 10240;
                byte[] buffer = new byte[MAGIC.length];
                map2.position(index -= MAGIC.length);
                map2.get(buffer);
                if (Helper.isMagicMatched(buffer)) {
                    map2.position(index -= 2);
                    short length = map2.getShort();
                    if (length > 0) {
                        map2.position(index -= length);
                        byte[] bytesComment = new byte[length];
                        map2.get(bytesComment);
                        String string = new String(bytesComment, UTF_8);
                        return string;
                    }
                }
            }
            finally {
                if (map2 != null) {
                    map2.clear();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            return null;
        }

        public static void writeMarket(File file, String market) throws IOException {
            Helper.writeZipComment(file, market);
        }

        public static String readMarket(File file) throws IOException {
            return Helper.readZipComment(file);
        }

        public static boolean verifyMarket(File file, String market) throws IOException {
            return market.equals(Helper.readMarket(file));
        }

        public static void println(String msg) {
            System.out.println(msg);
        }

        public static void printErr(String msg) {
            System.err.println(msg);
        }

        public static List<String> parseMarkets(File file) throws IOException {
            ArrayList<String> markets = new ArrayList<String>();
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            int lineNo = 1;
            while ((line = br.readLine()) != null) {
                String market;
                String[] parts = line.split("#");
                if (parts.length > 0 && (market = parts[0].trim()).length() > 0) {
                    markets.add(market);
                }
                ++lineNo;
            }
            br.close();
            fr.close();
            return markets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void copyFile(File src, File dest) throws IOException {
            if (!dest.exists()) {
                dest.createNewFile();
            }
            FileChannel source = null;
            AbstractInterruptibleChannel destination = null;
            try {
                source = new FileInputStream(src).getChannel();
                destination = new FileOutputStream(dest).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
        }

        public static boolean deleteDir(File dir) {
            File[] files = dir.listFiles();
            if (files == null || files.length == 0) {
                return false;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    Helper.deleteDir(file);
                    continue;
                }
                file.delete();
            }
            return true;
        }

        public static String getExtension(String fileName) {
            int dot = fileName.lastIndexOf(".");
            if (dot > 0) {
                return fileName.substring(dot + 1);
            }
            return null;
        }

        public static String getBaseName(String fileName) {
            int dot = fileName.lastIndexOf(".");
            if (dot > 0) {
                return fileName.substring(0, dot);
            }
            return fileName;
        }
    }

    public static class MarketNotFoundException
    extends IOException {
        public MarketNotFoundException() {
        }

        public MarketNotFoundException(String message) {
            super(message);
        }
    }

    public static class MarketExistsException
    extends IOException {
        public MarketExistsException() {
        }

        public MarketExistsException(String message) {
            super(message);
        }
    }

    public static final class MarketInfo {
        public final String market;
        public final Exception error;

        public MarketInfo(String market, Exception error) {
            this.market = market;
            this.error = error;
        }

        public String toString() {
            return "MarketInfo{market='" + this.market + '\'' + ", error=" + this.error + '}';
        }
    }
}

