/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ltv/athena/util/StorageUtils;", "", "()V", "EXTERNAL_STORAGE_PERMISSION", "", "getCacheDir", "Ljava/io/File;", "context", "Landroid/content/Context;", "getExternalCacheDir", "hasExternalStoragePermission", "", "utils-mini_release"})
public final class StorageUtils {
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    public static final StorageUtils INSTANCE;

    @NotNull
    public final File getCacheDir(@NotNull Context context) {
        File appCacheDir;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Build.VERSION.SDK_INT > 28) {
                File file = context.getExternalCacheDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.externalCacheDir");
                return file;
            }
            File file = context.getCacheDir();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.cacheDir");
            appCacheDir = file;
            if (!Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState()) || !this.hasExternalStoragePermission(context)) break block2;
            File file2 = this.getExternalCacheDir(context);
            if (file2 != null) {
                File file3 = file2;
                boolean bl = false;
                boolean bl2 = false;
                File it = file3;
                boolean bl3 = false;
                appCacheDir = it;
            }
        }
        return appCacheDir;
    }

    private final File getExternalCacheDir(Context context) {
        File file = context.getExternalCacheDir();
        if (file != null && file.canWrite()) {
            return context.getExternalCacheDir();
        }
        File dataDir = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File appCacheDir = new File(new File(dataDir, context.getPackageName()), "cache");
        if (!appCacheDir.exists() && !appCacheDir.mkdirs() || !appCacheDir.canWrite()) {
            return null;
        }
        return appCacheDir;
    }

    private final boolean hasExternalStoragePermission(Context context) {
        return context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION) == 0;
    }

    private StorageUtils() {
    }

    static {
        StorageUtils storageUtils;
        INSTANCE = storageUtils = new StorageUtils();
    }
}

