package tv.athena.live.component.business.videoarea

import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import com.thunder.livesdk.ThunderVideoCanvas
import com.thunder.livesdk.video.ThunderPlayerMultiView
import tv.athena.core.sly.Sly
import tv.athena.klog.api.KLog
import tv.athena.live.base.arch.IComponentViewModel
import tv.athena.live.base.manager.CommonViewModel
import tv.athena.live.basesdk.thunderblotwrapper.AbscThunderEventListener
import tv.athena.live.basesdk.thunderblotwrapper.ThunderHandle
import tv.athena.live.utils.ALog
import java.lang.ref.WeakReference

/**
 * Created by qiushunming on 2019-08-07.
 */
class VideoAreaViewModel : AbscThunderEventListener(), IComponentViewModel {
    private val mRemoteVideoCanvasRefs = mutableMapOf<String, WeakReference<ThunderVideoCanvas>>()
    private var mThunderPlayerMultiView: ThunderPlayerMultiView? = null
    private var mComponent: VideoAreaComponent? = null
    private var mCommonViewModel: CommonViewModel? = null
    private var mThunderHandle: ThunderHandle? = null

    init {
        //Sly.subscribe(this)
    }

    fun onAllComponentsReady() {
    }

    fun setComponent(component: VideoAreaComponent) {
        ALog.i(TAG, "setComponent($component)")
        this.mComponent = component
        this.mCommonViewModel = component.componentContext.commonViewModel
        this.mThunderHandle = component.componentContext.thunderHandle
    }

    fun onCreate(component: VideoAreaComponent) {
        ALog.i(TAG, "onCreate($component)")
        Sly.subscribe(this)
        setComponent(component)
    }

    fun switchRemotePreviewContainer(sid: String, remoteUid: String, viewContainer: ViewGroup?) {
        if (TextUtils.isEmpty(remoteUid) || viewContainer == null) {
            ALog.e(TAG, "switchRemotePreviewContainer remoteUid: $remoteUid , viewContainer: $viewContainer")
            return
        }

        val thunderVideoCanvas = mRemoteVideoCanvasRefs[remoteUid]?.get()
        if (thunderVideoCanvas?.mView == null) {
            ALog.i(TAG, "Replace a invalid remote preview: uid=$remoteUid")
            return
        }

        val playView = thunderVideoCanvas.mView as View

        //确保解除
        playView.parent?.let { parent ->
            (parent as ViewGroup).removeView(playView)
        }

        viewContainer.removeAllViews()
        viewContainer.addView(playView, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
    }

    fun destroy() {
        KLog.i(TAG, "destroy")
        Sly.unSubscribe(this)
        //确保解除
        mRemoteVideoCanvasRefs.forEach {
            it?.value?.get().let { thunderVideoCanvas ->
                val playView = thunderVideoCanvas?.mView as View?
                playView?.parent?.let { parent ->
                    (parent as ViewGroup).removeView(playView)
                }
            }
        }
        mRemoteVideoCanvasRefs.clear()
    }

    companion object {
        private const val TAG = "VideoAreaViewModel"
    }
}
