package tv.athena.live.component.business.utils

import android.text.TextUtils
import com.yy.liveplatform.proto.nano.LpfConfig
import com.yy.liveplatform.proto.nano.LpfLiveroomtemplateV2
import com.yy.liveplatform.proto.nano.LpfMedia
import tv.athena.live.api.wath.MediaProtocol
import tv.athena.live.api.wath.MediaType
import tv.athena.live.api.wath.bean.LineStreamInfo
import tv.athena.live.basesdk.config.BaseDataConfig
import tv.athena.live.utils.ALog
import tv.athena.util.encode.Base64Utils
import java.util.LinkedList
import kotlin.collections.sortedBy as sortedBy1

/**
 * Created by liuyongyuan on 2020/9/27.
 */
object ATHVideoUtils {
    const val TAG = "VideoUtils"

    fun parseLineStreamInfo(roomInfV2Msg: String?): List<LineStreamInfo>? {
        try {
            if (TextUtils.isEmpty(roomInfV2Msg)) {
                ALog.e(TAG, "roomInfV2Msg is empty")
                return null
            }
            val message = Base64Utils.decode(roomInfV2Msg, Base64Utils.DEFAULT)
            val roomInfoV2 = LpfLiveroomtemplateV2.LiveRoomInfoV2.parseFrom(message)
            ALog.i(TAG, "handleRoomInfoV2 [ streamRoomId : ${roomInfoV2.channelInfo?.streamRoomId}  ; " +
                " audienceCdnStatus ${roomInfoV2.audienceCdnStatus} ]")
            val audienceStreamInfos = roomInfoV2.audienceLineStreamInfos
            val mNewAudienceStreamInfos = LinkedList<LineStreamInfo>()
            val selectionStrategies = BaseDataConfig.getStrategy()?.selectionStrategies?.associateBy(
                LpfConfig.AudienceStreamStrategy.SelectionStrategy::serviceProvider,
                LpfConfig.AudienceStreamStrategy.SelectionStrategy::mediaProtocols
            )?.apply {
                keys.forEach {
                    ALog.i(TAG, "selectionStrategies [key: $it ] - [value : ${getValue(it)} ]")
                }
            }
            val selectionQuicStrategies = BaseDataConfig.getStrategy()?.selectionStrategies?.associateBy(
                LpfConfig.AudienceStreamStrategy.SelectionStrategy::serviceProvider,
                LpfConfig.AudienceStreamStrategy.SelectionStrategy::isSupportQuic
            )?.apply {
                keys.forEach {
                    ALog.i(TAG, "selectionQuicStrategies [key: $it ] - [value : ${getValue(it)}")
                }
            }
            if (selectionStrategies == null) {
                //如果拿不到该数据，直接通知cdn 挂载走源流播放
                ALog.i(TAG, "handleRoomInfoV2 selectionStrategies == null")
                return null
            }
            audienceStreamInfos.filter {
                val serviceProvider = it.serviceProvider
                selectionStrategies.containsKey(serviceProvider)
            }.sortedBy1 {
                selectionStrategies.keys?.indexOf(it.serviceProvider) ?: 0
            }.forEach { audienceLineStreamInfo ->
                val provider = audienceLineStreamInfo.serviceProvider
                val mediaProtocols = selectionStrategies!![provider]?.toList()
                var isSupportQuic = false
                selectionQuicStrategies?.let {
                    isSupportQuic = it[provider] ?: false
                }
                audienceLineStreamInfo.audienceStreamInfos.forEach { audienceStreamInfo ->
                    val joinStreamUids = audienceStreamInfo.joinStreamUids.toList()

                    val streamRoomId = roomInfoV2.channelInfo?.streamRoomId
                    audienceStreamInfo.streamInfos.filter { commonStreamInfo ->
                        val mediaProtocol = commonStreamInfo.mediaProtocol
                        mediaProtocols?.contains(mediaProtocol) == true
                    }.forEach {
                        val streamUrls = it.streamUrls.toList()
                        val streamDefinition = it.streamDefinition
                        val mediaProtocol = when (it.mediaProtocol) {
                            LpfLiveroomtemplateV2.MP_THUNDER_BOLOT -> MediaProtocol.THUNDER_BOLOT
                            LpfLiveroomtemplateV2.MP_FLV -> MediaProtocol.FLV
                            LpfLiveroomtemplateV2.MP_RTMP -> MediaProtocol.RTMP
                            LpfLiveroomtemplateV2.MP_HLS -> MediaProtocol.HLS
                            else -> MediaProtocol.THUNDER_BOLOT
                        }

                        val mediaType = when (it.mediaType) {
                            LpfMedia.MT_VIDEO -> MediaType.MT_VIDEO
                            LpfMedia.MT_AUD -> MediaType.MT_AUDIO
                            LpfMedia.MT_AV -> MediaType.MT_AV
                            LpfMedia.MT_NONE -> MediaType.NONE
                            else -> MediaType.MT_AV
                        }
                        val lineStreamInfo = LineStreamInfo(provider,
                            streamRoomId,
                            joinStreamUids,
                            mediaType,
                            mediaProtocol,
                            streamUrls,
                            streamDefinition,
                            it.videoWidth,
                            it.videoHeight,
                            it.videoBitrate,
                            it.videoFrameRate, isSupportQuic = isSupportQuic,
                            configResolution = it.configResolution)
                        mNewAudienceStreamInfos.add(lineStreamInfo)
                    }
                }
            }
            return mNewAudienceStreamInfos
        } catch (e: Throwable) {
            ALog.e(TAG, "parseLineInfo", e)
        }
        return null
    }
}