package tv.athena.live.component.business.roominfo.repository.service.impl;

import android.arch.lifecycle.MutableLiveData;

import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.yy.liveplatform.proto.nano.LpfLiveinfo;
import com.yy.liveplatform.proto.nano.LpfLiveroomtemplate;

import tv.athena.live.utils.ServiceUtils;
import tv.athena.live.component.business.roominfo.repository.service.IRoomInfoService;
import tv.athena.live.utils.ALog;
import tv.athena.service.api.IMessageCallback;
import tv.athena.service.api.event.ServiceBroadcastEvent;

/**
 * @author : liaojidong
 * @e-mail : liaojidong@joyy.sg
 * @date : 2019/8/26 10:43
 * @desc :
 */
public class RoomInfoService implements IRoomInfoService {
    private static final String SERVICE_NAME = "lpfLiveRoomTemplate";
    private static final String FUNC_GET_LIVE_ROOM_INFO = "getLiveRoomInfo";
    private static final String FUNC_UPDATE_LIVE_ROOM_INFO_BROADCAST = "updateLiveRoomInfoBroadcast";
    private static final String FUNC_GET_LIVE_INFO_BY_SID = "getLiveInfoBySid";
    private static final String FUNC_GET_LIVE_INFO_BY_UID = "getLiveInfoByUid";

    @Override
    public void getLiveInfoBySidReq(LpfLiveinfo.GetLiveInfoBySidReq req,
                                    IMessageCallback<LpfLiveinfo.GetLiveInfoBySidResp> callback) {
        ServiceUtils.ServiceReq serviceReq = new ServiceUtils.ServiceReq();
        serviceReq.mReqParam = req;
        serviceReq.mFunctionName = FUNC_GET_LIVE_INFO_BY_SID;
        serviceReq.mServerName = SERVICE_NAME;
        ServiceUtils.send(serviceReq, callback);
    }

    @Override
    public void getLiveInfoByUidReq(LpfLiveinfo.GetLiveInfoByUidReq req,
                                    IMessageCallback<LpfLiveinfo.GetLiveInfoByUidResp> callback) {
        ServiceUtils.ServiceReq serviceReq = new ServiceUtils.ServiceReq();
        serviceReq.mReqParam = req;
        serviceReq.mFunctionName = FUNC_GET_LIVE_INFO_BY_UID;
        serviceReq.mServerName = SERVICE_NAME;
        ServiceUtils.send(serviceReq, callback);
    }

    @Override
    public void getLiveRoomInfo(LpfLiveroomtemplate.GetLiveRoomInfoReq req,
                                IMessageCallback<LpfLiveroomtemplate.GetLiveRoomInfoResp> callback) {
        ServiceUtils.ServiceReq serviceReq = new ServiceUtils.ServiceReq();
        serviceReq.mReqParam = req;
        serviceReq.mFunctionName = FUNC_GET_LIVE_ROOM_INFO;
        serviceReq.mServerName = SERVICE_NAME;
        ServiceUtils.send(serviceReq, callback);
    }

    @Override
    public boolean handleUpdateLiveRoomInfoBroadcast(MutableLiveData<LpfLiveroomtemplate.LiveRoomInfo> liveRoomInfo,
                                                     ServiceBroadcastEvent event) {
        if (event == null) {
            return false;
        }
        try {
            if (FUNC_UPDATE_LIVE_ROOM_INFO_BROADCAST.equals(event.getFuncName())) {
                ALog.i("RoomInfoService", FUNC_UPDATE_LIVE_ROOM_INFO_BROADCAST);
                LpfLiveroomtemplate.UpdateLiveRoomInfoBroadcast broadcast =
                    LpfLiveroomtemplate.UpdateLiveRoomInfoBroadcast
                        .parseFrom(event.getMessage());
                if (broadcast != null) {
                    ALog.i("RoomInfoService", "liveRoomInfo " + broadcast.liveRoomInfo);
                    liveRoomInfo.setValue(broadcast.liveRoomInfo);
                    return true;
                }
            }
        } catch (InvalidProtocolBufferNanoException e) {
            e.printStackTrace();
        }
        return false;
    }
}
