package tv.athena.live.component.business.report.cache;

import android.os.Handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import tv.athena.live.utils.ALog;

public class RoomCachedAudio {
    private HashMap<Long, UserCachedAudio> mAudioData = new HashMap<>();
    private static final String TAG = "RoomCachedAudio";

    private boolean mWillCheck;
    private Handler mHandler = new Handler();
    private Runnable mDiscardExpiredDataRunnable = new Runnable() {
        @Override
        public void run() {
            discardExpiredData();
            mWillCheck = false;
        }
    };

    public void cacheAudioData(Long uid, byte[] audioData, long duration) {
        UserCachedAudio userAudio = mAudioData.get(uid);
        if (null == userAudio) {
            userAudio = new UserCachedAudio();
            synchronized (this) {
                mAudioData.put(uid, userAudio);
            }

            ALog.i(TAG, "cache user " + uid);
        }

        if (audioData != null && audioData.length > 0) {
            long curTime = System.currentTimeMillis();
            userAudio.discardExpiredData(curTime - AudioCacheConfig.mCacheDuration); // 先回收,回收的结点可以给新增的数据复用
            userAudio.addData(audioData, curTime, duration);
            toCheckExpiredData();
        }
    }

    public byte[] getUserCachedAudio(long uid, long expiredTime) {
        UserCachedAudio userAudio = mAudioData.get(uid);
        if (userAudio != null) {
            return userAudio.getCachedAudio(expiredTime);
        }

        return null;
    }

    public synchronized HashMap<Long, byte[]> getCachedAudio(long expiredTime) {
        HashMap<Long, byte[]> cachedAudio = new HashMap<>();
        for (Map.Entry<Long, UserCachedAudio> entry : mAudioData.entrySet()) {
            UserCachedAudio userCachedAudio = entry.getValue();
            byte[] data = userCachedAudio.getCachedAudio(expiredTime);
            if (data != null) {
                cachedAudio.put(entry.getKey(), data);
            }
        }

        return cachedAudio;
    }

    public void reset() {
        mHandler.removeCallbacks(mDiscardExpiredDataRunnable);
        mWillCheck = false;
    }

    private void toCheckExpiredData() {
        if (mWillCheck) {
            return;
        }

        mHandler.postDelayed(mDiscardExpiredDataRunnable, AudioCacheConfig.mCacheDuration);
        mWillCheck = true;
    }

    private synchronized void discardExpiredData() {
        long expieredTime = System.currentTimeMillis() - AudioCacheConfig.mCacheDuration;
        Iterator<UserCachedAudio> iterator = mAudioData.values().iterator();
        while (iterator.hasNext()) {
            UserCachedAudio userCachedAudio = iterator.next();
            userCachedAudio.discardExpiredData(expieredTime);
        }

        ALog.i(AudioCacheConfig.TAG, "after discardExpiredData, cached size: " +
            AudioCacheConfig.mCurCachedSize);
    }
}
