package tv.athena.live.component.business.broadcasting

import tv.athena.live.base.arch.IComponentViewModel
import tv.athena.live.utils.ALog

/**
 *    create by chenhaofeng 2019-08-13
 *
 */
class BroadcastViewModel : IComponentViewModel {
    companion object {
        const val TAG = "BroadcastViewModel"
    }

    var iBroadcast: IBroadcast? = null

    fun onCreate(component: BroadcastComponent) {
        iBroadcast?.setComponent(component)
    }

    fun onLeave() {
        iBroadcast?.onLeave()
    }

    fun onDestroy() {
        iBroadcast?.onDestroy()
    }

    fun setComponent(component: BroadcastComponent) {
        component.componentContext?.let {
            ALog.i(TAG, "BroadcastViewModel (liveRoomBzMode : $it)")
            iBroadcast = BroadcastNormalImpl()
            (iBroadcast as BroadcastNormalImpl).setComponent(component)
        }
    }
}