/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.live.component.business.activitybar.webview.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

public final class ScheduledTask {
    private volatile Looper mTaskLooper;
    private volatile Handler mTaskHandler;
    private HandlerThread thread = new HandlerThread("ScheduledTask");
    private static volatile ScheduledTask inStance;

    private ScheduledTask() {
        this.thread.start();
        this.mTaskLooper = this.thread.getLooper();
        this.mTaskHandler = new Handler(this.mTaskLooper);
    }

    public void setThreadPriority(int priority) {
        if (this.thread.getPriority() != priority) {
            this.thread.setPriority(priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduledTask getInstance() {
        if (inStance != null) return inStance;
        Class<ScheduledTask> clazz = ScheduledTask.class;
        synchronized (ScheduledTask.class) {
            if (inStance != null) return inStance;
            inStance = new ScheduledTask();
            // ** MonitorExit[var0] (shouldn't be in output)
            return inStance;
        }
    }

    public boolean scheduledDelayed(Runnable command, long delay) {
        this.mTaskHandler.removeCallbacks(command);
        return this.mTaskHandler.postDelayed(command, delay);
    }

    public boolean scheduledAtTime(Runnable command, long uptimeMillis) {
        this.mTaskHandler.removeCallbacks(command);
        return this.mTaskHandler.postAtTime(command, uptimeMillis);
    }

    public void removeCallbacks(Runnable command) {
        this.mTaskHandler.removeCallbacks(command);
    }

    public boolean isInterrupted() {
        return this.thread != null && this.thread.isInterrupted();
    }
}

