package tv.athena.live.base.manager

import java.util.ArrayList

/**
 *     create by chenhaofeng 2019/12/11
 *
 *
 **/
class InitComponentHelper {

    private val BROADCASTCOMPONENT = "tv.athena.live.component.business.broadcasting.BroadcastComponent"

    private val LINKMICCOMPONENT = "tv.athena.live.component.business.link_mic.LinkMicComponent"

    private val VIDEOAREACOMPONENT = "tv.athena.live.component.business.videoarea.VideoAreaComponent"

    private val ROOMINFOCOMPONENT = "tv.athena.live.component.business.roominfo.RoomInfoComponent"

    private val AUDIENCECOMPONENT = "tv.athena.live.component.business.audience.AudienceComponent"

    private val REPORTCOMPONENT = "tv.athena.live.component.business.report.ReportComponent"

    private val ACTIVITYBARCOMPONENT = "tv.athena.live.component.business.activitybar.ActivityBarComponent"

    private val CHANNELCOMPONENT = "tv.athena.live.component.business.channel.ChannelComponent"

    private val ADMINCOMPONENT = "tv.athena.live.component.business.admin.AdminComponent"

    private val CHATROOMCOMPONENT = "tv.athena.live.component.business.chatroom.ChatRoomComponent"

    private val mComponents = ArrayList<String>()

    /**
     * 开播模块  */
    fun initBroadcastComponent(): InitComponentHelper {
        if (!mComponents.contains(BROADCASTCOMPONENT)) {
            mComponents.add(BROADCASTCOMPONENT)
        }
        return this
    }

    /**
     * 连麦模块
     *
     * */
    fun initLinkMicComponent(): InitComponentHelper {
        if (!mComponents.contains(LINKMICCOMPONENT)) {
            mComponents.add(LINKMICCOMPONENT)
        }
        return this
    }

    /**
     * 观看模块
     *
     * */
    fun initVideoAreaComponent(): InitComponentHelper {
        if (!mComponents.contains(VIDEOAREACOMPONENT)) {
            mComponents.add(VIDEOAREACOMPONENT)
        }
        return this
    }

    /**
     * 房间信息模块
     *
     * */
    fun initRoomInfoComponent(): InitComponentHelper {
        if (!mComponents.contains(ROOMINFOCOMPONENT)) {
            mComponents.add(ROOMINFOCOMPONENT)
        }
        return this
    }

    /**
     * 观众席模块
     *
     * */
    fun initAudienceComponent(): InitComponentHelper {
        if (!mComponents.contains(AUDIENCECOMPONENT)) {
            mComponents.add(AUDIENCECOMPONENT)
        }
        return this
    }

    /**
     * 反馈模块
     *
     * */
    fun initReportComponent(): InitComponentHelper {
        if (!mComponents.contains(REPORTCOMPONENT)) {
            mComponents.add(REPORTCOMPONENT)
        }
        return this
    }

    /**
     * 活动页模块
     *
     * */
    fun initActivityBarComponent(): InitComponentHelper {
        if (!mComponents.contains(ACTIVITYBARCOMPONENT)) {
            mComponents.add(ACTIVITYBARCOMPONENT)
        }
        return this
    }

    /**
     * 频道模块
     *
     * */
    fun initChannelComponent(): InitComponentHelper {
        if (!mComponents.contains(CHANNELCOMPONENT)) {
            mComponents.add(CHANNELCOMPONENT)
        }
        return this
    }

    /**
     * 管理员模块
     *
     * */
    fun initAdminComponent(): InitComponentHelper {
        if (!mComponents.contains(ADMINCOMPONENT)) {
            mComponents.add(ADMINCOMPONENT)
        }
        return this
    }

    /**
     * 聊天室模块
     *
     * */
    fun initChatRoomComponent(): InitComponentHelper {
        if (!mComponents.contains(CHATROOMCOMPONENT)) {
            mComponents.add(CHATROOMCOMPONENT)
        }
        return this
    }

    /**
     * 默认初始化所有模块默认初始化所有模块默认初始化所有模块默认初始化所有模块默认初始化所有模块默认初始化所有模块默认初始化所有模块  */
    fun initAllComponents() {
        if (!mComponents.contains(BROADCASTCOMPONENT)) {
            mComponents.add(BROADCASTCOMPONENT)
        }
        if (!mComponents.contains(LINKMICCOMPONENT)) {
            mComponents.add(LINKMICCOMPONENT)
        }
        if (!mComponents.contains(VIDEOAREACOMPONENT)) {
            mComponents.add(VIDEOAREACOMPONENT)
        }
        if (!mComponents.contains(ROOMINFOCOMPONENT)) {
            mComponents.add(ROOMINFOCOMPONENT)
        }
        if (!mComponents.contains(AUDIENCECOMPONENT)) {
            mComponents.add(AUDIENCECOMPONENT)
        }
        if (!mComponents.contains(REPORTCOMPONENT)) {
            mComponents.add(REPORTCOMPONENT)
        }
        if (!mComponents.contains(ACTIVITYBARCOMPONENT)) {
            mComponents.add(ACTIVITYBARCOMPONENT)
        }
        if (!mComponents.contains(CHANNELCOMPONENT)) {
            mComponents.add(CHANNELCOMPONENT)
        }
        if (!mComponents.contains(ADMINCOMPONENT)) {
            mComponents.add(ADMINCOMPONENT)
        }
        if (!mComponents.contains(CHATROOMCOMPONENT)) {
            mComponents.add(CHATROOMCOMPONENT)
        }
    }

    fun getComponents(): ArrayList<String> {
        return mComponents
    }
}