/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.util;

import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J&\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltv/athena/ipc/util/CallbackManager;", "", "()V", "MAX_INDEX", "", "TAG", "", "mCallbackWrappers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ltv/athena/ipc/util/CallbackManager$CallbackWrapper;", "addCallback", "", "timeStamp", "index", "callback", "isWeakRef", "", "uiThread", "getCallback", "Lkotlin/Pair;", "getKey", "removeCallback", "CallbackWrapper", "ipc_release"})
public final class CallbackManager {
    private static final String TAG = "CallbackManager";
    private static final int MAX_INDEX = 10;
    private static ConcurrentHashMap<Long, CallbackWrapper> mCallbackWrappers;
    public static final CallbackManager INSTANCE;

    private final long getKey(long timeStamp, int index) {
        if (index >= MAX_INDEX) {
            throw (Throwable)new IllegalArgumentException("Index should be less than " + MAX_INDEX);
        }
        return timeStamp * (long)MAX_INDEX + (long)index;
    }

    public final void addCallback(long timeStamp, int index, @NotNull Object callback, boolean isWeakRef, boolean uiThread) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        long key = this.getKey(timeStamp, index);
        Map map = mCallbackWrappers;
        Long l = key;
        CallbackWrapper callbackWrapper = new CallbackWrapper(isWeakRef, callback, uiThread);
        map.put(l, callbackWrapper);
    }

    @Nullable
    public final Pair<Boolean, Object> getCallback(long timeStamp, int index) {
        long key = this.getKey(timeStamp, index);
        CallbackWrapper callbackWrapper = mCallbackWrappers.get(key);
        if (callbackWrapper == null) {
            return null;
        }
        CallbackWrapper callbackWrapper2 = callbackWrapper;
        Pair<Boolean, Object> pair = callbackWrapper2.get();
        if (pair.getSecond() == null) {
            mCallbackWrappers.remove(key);
        }
        return pair;
    }

    public final void removeCallback(long timeStamp, int index) {
        long key = this.getKey(timeStamp, index);
        if (mCallbackWrappers.remove(key) == null) {
            Log.e((String)TAG, (String)"An error occurs in the callback GC.");
        }
    }

    private CallbackManager() {
    }

    static {
        CallbackManager callbackManager;
        INSTANCE = callbackManager = new CallbackManager();
        TAG = TAG;
        MAX_INDEX = 10;
        mCallbackWrappers = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tR\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltv/athena/ipc/util/CallbackManager$CallbackWrapper;", "", "isWeakRef", "", "callback", "mUiThread", "(ZLjava/lang/Object;Z)V", "mCallback", "get", "Lkotlin/Pair;", "ipc_release"})
    private static final class CallbackWrapper {
        private Object mCallback;
        private final boolean mUiThread;

        @NotNull
        public final Pair<Boolean, Object> get() {
            Object object;
            if (this.mCallback instanceof WeakReference) {
                Object object2 = this.mCallback;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.ref.WeakReference<*>");
                }
                object = ((WeakReference)object2).get();
            } else {
                object = this.mCallback;
            }
            Object callback = object;
            return new Pair((Object)this.mUiThread, callback);
        }

        public CallbackWrapper(boolean isWeakRef, @NotNull Object callback, boolean mUiThread) {
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            this.mUiThread = mUiThread;
            this.mCallback = isWeakRef ? new WeakReference<Object>(callback) : callback;
        }
    }
}

