/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.internal;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import tv.athena.ipc.internal.CallbackMail;
import tv.athena.ipc.internal.Reply;

public interface IIPCServiceCallback
extends IInterface {
    public Reply callback(CallbackMail var1) throws RemoteException;

    public void gc(List<Long> var1, List<Integer> var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIPCServiceCallback {
        private static final String DESCRIPTOR = "tv.athena.ipc.internal.IIPCServiceCallback";
        static final int TRANSACTION_callback = 1;
        static final int TRANSACTION_gc = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIPCServiceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin instanceof IIPCServiceCallback) {
                return (IIPCServiceCallback)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    CallbackMail arg0 = 0 != data.readInt() ? (CallbackMail)CallbackMail.CREATOR.createFromParcel(data) : null;
                    Reply result = this.callback(arg0);
                    reply.writeNoException();
                    if (result != null) {
                        reply.writeInt(1);
                        result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    ClassLoader cl = this.getClass().getClassLoader();
                    ArrayList list1 = data.readArrayList(cl);
                    ArrayList list2 = data.readArrayList(cl);
                    this.gc(list1, list2);
                    reply.writeNoException();
                    return true;
                }
            }
            Log.e((String)"Athena IPCImpl", (String)"Error occurs IIPCServiceCallback not handle");
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IIPCServiceCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Reply callback(CallbackMail mail) throws RemoteException {
                Reply result;
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (mail != null) {
                        data.writeInt(1);
                        mail.writeToParcel(data, 0);
                    } else {
                        data.writeInt(0);
                    }
                    this.mRemote.transact(1, data, reply, 0);
                    reply.readException();
                    result = 0 != reply.readInt() ? (Reply)Reply.CREATOR.createFromParcel(reply) : null;
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void gc(List<Long> timeStamps, List<Integer> indexes) throws RemoteException {
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken(Stub.DESCRIPTOR);
                    data.writeList(timeStamps);
                    data.writeList(indexes);
                    this.mRemote.transact(2, data, reply, 0);
                    reply.readException();
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
            }
        }
    }
}

