/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.util;

import android.text.TextUtils;
import java.lang.reflect.InvocationTargetException;

public class IPCException
extends Exception {
    private int mErrorCode;
    private String mErrorMessage;

    public IPCException(int errorCode, String errorMessage) {
        this.mErrorCode = errorCode;
        this.mErrorMessage = errorMessage;
    }

    public IPCException(int errorCode, String errorMessage, Throwable t) {
        super(t);
        this.mErrorCode = errorCode;
        this.mErrorMessage = errorMessage;
        if (t instanceof InvocationTargetException) {
            this.mErrorMessage = this.mErrorMessage + ((InvocationTargetException)t).getTargetException().getMessage();
        }
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    @Override
    public String getMessage() {
        return (TextUtils.isEmpty((CharSequence)super.getMessage()) ? "" : super.getMessage()) + "\n " + this.mErrorMessage;
    }

    @Override
    public String toString() {
        return this.getMessage() + " \n IPCException{mErrorCode=" + this.mErrorCode + ", mErrorMessage='" + this.mErrorMessage + '\'' + '}';
    }
}

