/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.ipc.receiver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import tv.athena.ipc.receiver.Receiver;
import tv.athena.ipc.util.IPCException;
import tv.athena.ipc.util.TypeUtils;
import tv.athena.ipc.wrapper.MethodWrapper;
import tv.athena.ipc.wrapper.ObjectWrapper;
import tv.athena.ipc.wrapper.ParameterWrapper;

public class InstanceCreatingReceiver
extends Receiver {
    private Class<?> mObjectClass;
    private Constructor<?> mConstructor;

    public InstanceCreatingReceiver(ObjectWrapper object) throws IPCException {
        super(object);
        Class<?> clazz = TYPE_CENTER.getClassType(object);
        TypeUtils.validateAccessible(clazz);
        this.mObjectClass = clazz;
    }

    @Override
    public void setMethod(MethodWrapper methodWrapper, ParameterWrapper[] parameterWrappers) throws IPCException {
        Constructor<?> constructor = TypeUtils.getConstructor(this.mObjectClass, TYPE_CENTER.getClassTypes(parameterWrappers));
        TypeUtils.validateAccessible(constructor);
        this.mConstructor = constructor;
        this.mConstructor.setAccessible(true);
        this.mParametersType = constructor.getGenericParameterTypes();
    }

    @Override
    protected Object invokeMethod() throws IPCException {
        ReflectiveOperationException exception;
        try {
            Object[] parameters = this.getParameters();
            Object object = parameters == null || parameters.length == 0 ? this.mConstructor.newInstance(new Object[0]) : this.mConstructor.newInstance(parameters);
            OBJECT_CENTER.putObject(this.getObjectTimeStamp(), object);
            return null;
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        exception.printStackTrace();
        throw new IPCException(18, "Error occurs when invoking constructor to create an instance of " + this.mObjectClass.getName(), exception);
    }
}

