/*
 * Decompiled with CFR 0.152.
 */
package tv.athena.core.sly;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tv.athena.annotation.MessageBinding;
import tv.athena.core.sly.SlyMessage;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002&'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\f\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00100\u0015j\b\u0012\u0004\u0012\u00020\u0010`\u00160\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ltv/athena/core/sly/SlyBridge;", "Landroid/os/Handler$Callback;", "()V", "TAG", "", "mIoHandler", "Landroid/os/Handler;", "mIoThread", "Landroid/os/HandlerThread;", "mLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "mMainHandler", "mMessageCenter", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Ljava/util/HashMap;", "Ltv/athena/core/sly/SlyBridge$IMessageHandler;", "Ltv/athena/core/sly/SlyBridge$IMessage;", "Lkotlin/collections/HashMap;", "mSlyCenter", "", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "existMessageBinding", "", "observer", "handleMessage", "msg", "Landroid/os/Message;", "register", "", "messageHandler", "sendMessage", "message", "Ltv/athena/core/sly/SlyMessage;", "subscribe", "unSubscribe", "unregister", "IMessage", "IMessageHandler", "core_release"})
public final class SlyBridge
implements Handler.Callback {
    private static final String TAG = "SlyBridge";
    private static final HandlerThread mIoThread;
    private static Handler mIoHandler;
    private static final Handler mMainHandler;
    private static final ConcurrentHashMap<Class<?>, HashMap<IMessageHandler, IMessage>> mMessageCenter;
    private static final ConcurrentHashMap<Object, ArrayList<IMessageHandler>> mSlyCenter;
    private static final ReentrantReadWriteLock mLock;
    public static final SlyBridge INSTANCE;

    public boolean handleMessage(@NotNull Message msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        return true;
    }

    public final void sendMessage(@NotNull SlyMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        mLock.readLock().lock();
        HashMap<IMessageHandler, IMessage> hashMap = mMessageCenter.get(message.getClass());
        if (hashMap != null) {
            Map $this$forEach$iv = hashMap;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Message m2;
                Map.Entry element$iv;
                Map.Entry map2 = element$iv = iterator.next();
                boolean bl2 = false;
                boolean sync = ((IMessage)map2.getValue()).getSync();
                boolean mainThread = ((IMessage)map2.getValue()).getMainThread();
                long delay = ((IMessage)map2.getValue()).getDelay();
                Message msg = new Message();
                msg.obj = message;
                if (sync) {
                    ((IMessageHandler)map2.getKey()).handlerMessage(msg);
                    continue;
                }
                if (mainThread) {
                    m2 = Message.obtain((Handler)mMainHandler, (Runnable)new Runnable(map2, msg){
                        final /* synthetic */ Map.Entry $map;
                        final /* synthetic */ Message $msg;

                        public final void run() {
                            ((IMessageHandler)this.$map.getKey()).handlerMessage(this.$msg);
                        }
                        {
                            this.$map = entry;
                            this.$msg = message;
                        }
                    });
                    if (delay > 0L) {
                        mMainHandler.sendMessageDelayed(m2, delay);
                        continue;
                    }
                    mMainHandler.sendMessage(m2);
                    continue;
                }
                m2 = Message.obtain((Handler)mIoHandler, (Runnable)new Runnable(map2, msg){
                    final /* synthetic */ Map.Entry $map;
                    final /* synthetic */ Message $msg;

                    public final void run() {
                        ((IMessageHandler)this.$map.getKey()).handlerMessage(this.$msg);
                    }
                    {
                        this.$map = entry;
                        this.$msg = message;
                    }
                });
                if (delay > 0L) {
                    mIoHandler.sendMessageDelayed(m2, delay);
                    continue;
                }
                mIoHandler.sendMessage(m2);
            }
        }
        mLock.readLock().unlock();
    }

    private final void register(IMessageHandler messageHandler) {
        mLock.writeLock().lock();
        Iterable $this$forEach$iv = messageHandler.messages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IMessage msg = (IMessage)element$iv;
            boolean bl = false;
            HashMap hashMap = mMessageCenter.get(msg.getEvent());
            if (hashMap == null) {
                boolean bl2 = false;
                hashMap = new HashMap();
            }
            HashMap hashMap2 = hashMap;
            boolean bl3 = false;
            boolean bl4 = false;
            HashMap it = hashMap2;
            boolean bl5 = false;
            HashMap hashMap3 = it;
            Intrinsics.checkExpressionValueIsNotNull(hashMap3, (String)"it");
            ((Map)hashMap3).put(messageHandler, msg);
            ((Map)mMessageCenter).put(msg.getEvent(), it);
        }
        mLock.writeLock().unlock();
    }

    private final void unregister(IMessageHandler messageHandler) {
        mLock.writeLock().lock();
        Iterable $this$forEach$iv = messageHandler.messages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IMessage it = (IMessage)element$iv;
            boolean bl = false;
            HashMap<IMessageHandler, IMessage> hashMap = mMessageCenter.get(it.getEvent());
            if (hashMap == null) continue;
            hashMap.remove(messageHandler);
        }
        mLock.writeLock().unlock();
    }

    private final boolean existMessageBinding(Object observer) {
        boolean bl;
        block1: {
            Method[] methodArray = observer.getClass().getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"observer.javaClass.methods");
            Method[] $this$any$iv = methodArray;
            boolean $i$f$any = false;
            Method[] methodArray2 = $this$any$iv;
            int n = methodArray2.length;
            for (int i = 0; i < n; ++i) {
                Method element$iv;
                Method it = element$iv = methodArray2[i];
                boolean bl2 = false;
                if (!(it.getAnnotation(MessageBinding.class) != null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean subscribe(@NotNull Object observer) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        ArrayList<IMessageHandler> slyBinder = mSlyCenter.get(observer);
        if (slyBinder != null || !this.existMessageBinding(observer)) {
            return false;
        }
        Method[] methodArray = observer.getClass().getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"observer.javaClass.methods");
        Method[] $this$filter$iv = methodArray;
        boolean $i$f$filter = false;
        Method[] methodArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = iterator[i];
            boolean bl = false;
            if (!(it.getAnnotation(MessageBinding.class) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Method method = (Method)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            Class<?> clazz = v1.getDeclaringClass();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"it.declaringClass");
            String string = clazz.getName();
            collection.add(string);
        }
        Iterable $this$forEach$iv = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                Constructor<?> constructor;
                String clazzName = it + "$$SlyBinder";
                Class<?> clazz = Class.forName(clazzName);
                Constructor<?> constructor2 = constructor = clazz.getDeclaredConstructor(Class.forName(it), SlyBridge.class);
                Intrinsics.checkExpressionValueIsNotNull(constructor2, (String)"constructor");
                constructor2.setAccessible(true);
                Object instance = constructor.newInstance(observer, INSTANCE);
                if (instance instanceof IMessageHandler) {
                    Object object = observer;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    synchronized (object) {
                        boolean bl4 = false;
                        ArrayList arrayList = mSlyCenter.get(observer);
                        if (arrayList == null) {
                            boolean bl5 = false;
                            arrayList = new ArrayList();
                        }
                        ArrayList arrayList2 = arrayList;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        ArrayList it2 = arrayList2;
                        boolean bl8 = false;
                        it2.add(instance);
                        Map map = mSlyCenter;
                        ArrayList arrayList3 = it2;
                        Intrinsics.checkExpressionValueIsNotNull(arrayList3, (String)"it");
                        map.put(observer, arrayList3);
                        Unit unit = Unit.INSTANCE;
                    }
                    INSTANCE.register((IMessageHandler)instance);
                    continue;
                }
                return false;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)(observer + " subscribe sly fail, the reason is " + e.getMessage()));
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unSubscribe(@NotNull Object observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        if (mSlyCenter.get(observer) != null) {
            ArrayList<IMessageHandler> iMessageHandlers = mSlyCenter.remove(observer);
            if (iMessageHandlers != null) {
                boolean bl = false;
                boolean bl2 = false;
                synchronized (observer) {
                    boolean bl3 = false;
                    Iterable $this$forEach$iv = iMessageHandlers;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IMessageHandler it = (IMessageHandler)element$iv;
                        boolean bl4 = false;
                        INSTANCE.unregister(it);
                    }
                    iMessageHandlers.clear();
                    Unit unit = Unit.INSTANCE;
                }
            }
            return true;
        }
        return false;
    }

    private SlyBridge() {
    }

    static {
        SlyBridge slyBridge;
        INSTANCE = slyBridge = new SlyBridge();
        mIoThread = new HandlerThread("SlyBridgeIOThread");
        mMainHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)slyBridge);
        mMessageCenter = new ConcurrentHashMap();
        mSlyCenter = new ConcurrentHashMap();
        mLock = new ReentrantReadWriteLock(true);
        mIoThread.start();
        mIoHandler = new Handler(mIoThread.getLooper(), (Handler.Callback)slyBridge);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0010\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015\u00a8\u0006\u0018"}, d2={"Ltv/athena/core/sly/SlyBridge$IMessage;", "", "event", "Ljava/lang/Class;", "mainThread", "", "sync", "delay", "", "(Ljava/lang/Class;ZZJ)V", "getDelay", "()J", "setDelay", "(J)V", "getEvent", "()Ljava/lang/Class;", "setEvent", "(Ljava/lang/Class;)V", "getMainThread", "()Z", "setMainThread", "(Z)V", "getSync", "setSync", "core_release"})
    public static final class IMessage {
        @NotNull
        private Class<?> event;
        private boolean mainThread;
        private boolean sync;
        private long delay;

        @NotNull
        public final Class<?> getEvent() {
            return this.event;
        }

        public final void setEvent(@NotNull Class<?> clazz) {
            Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
            this.event = clazz;
        }

        public final boolean getMainThread() {
            return this.mainThread;
        }

        public final void setMainThread(boolean bl) {
            this.mainThread = bl;
        }

        public final boolean getSync() {
            return this.sync;
        }

        public final void setSync(boolean bl) {
            this.sync = bl;
        }

        public final long getDelay() {
            return this.delay;
        }

        public final void setDelay(long l) {
            this.delay = l;
        }

        public IMessage(@NotNull Class<?> event, boolean mainThread, boolean sync, long delay) {
            Intrinsics.checkParameterIsNotNull(event, (String)"event");
            this.event = event;
            this.mainThread = mainThread;
            this.sync = sync;
            this.delay = delay;
        }

        public /* synthetic */ IMessage(Class clazz, boolean bl, boolean bl2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                l = 0L;
            }
            this(clazz, bl, bl2, l);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tH&\u00a8\u0006\n"}, d2={"Ltv/athena/core/sly/SlyBridge$IMessageHandler;", "", "handlerMessage", "", "message", "Landroid/os/Message;", "messages", "Ljava/util/ArrayList;", "Ltv/athena/core/sly/SlyBridge$IMessage;", "Lkotlin/collections/ArrayList;", "core_release"})
    public static interface IMessageHandler {
        @NotNull
        public ArrayList<IMessage> messages();

        public void handlerMessage(@NotNull Message var1);
    }
}

