package tv.athena.annotation

/**
 * @author huangfan(kael)
 * @time 2018/5/23 17:25
 * sly框架注解
 */

/**
 * id : messageId
 * sync : 是否同步调用
 * mainThread : 是否主线程调用（sync为false才有效）
 * delay : 是否延迟执行（0 就不延迟）
 */
@Target(AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.RUNTIME)
annotation class MessageBinding(val scheduler: Int = Scheduler.main, val delay: Long = 0)

object Scheduler {

    /**
     * 主线程调用
     */
    const val main = 0

    /**
     * 子线程调用
     */
    const val io = 1

    /**
     * 当前线程同步调用
     */
    const val sync = 2
}