package tv.athena.annotation

import kotlin.reflect.KClass

/**
 * Created by 张世竹 on 2018/6/13
 */
@Target(AnnotationTarget.CLASS)
@Retention(AnnotationRetention.BINARY)
annotation class DataBaseCreate(val dbName: String = "demo.db", val version: Int = 1)

@Target(AnnotationTarget.CLASS, AnnotationTarget.FUNCTION, AnnotationTarget.FUNCTION)
@Retention(AnnotationRetention.BINARY)
annotation class DataBaseTable(val entityClass: KClass<*>, val daoClass: KClass<*>)

@Target(AnnotationTarget.FIELD)
@Retention(AnnotationRetention.BINARY)
annotation class DatabaseMigration(val migration: String)