/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.comments.github.lib;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.CommitComment;
import org.eclipse.egit.github.core.CommitFile;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;
import se.bjurr.violations.comments.github.lib.GitHubClientTestable;
import se.bjurr.violations.comments.github.lib.ViolationCommentsToGitHubApi;
import se.bjurr.violations.comments.lib.CommentsProvider;
import se.bjurr.violations.comments.lib.PatchParser;
import se.bjurr.violations.comments.lib.ViolationsLogger;
import se.bjurr.violations.comments.lib.model.ChangedFile;

public class GitHubCommentsProvider
implements CommentsProvider {
    private static final String TYPE_DIFF = "TYPE_DIFF";
    private static final String TYPE_PR = "TYPE_PR";
    private final IssueService issueSerivce;
    private final String pullRequestCommit;
    private final PullRequestService pullRequestService;
    private final RepositoryId repository;
    private final ViolationCommentsToGitHubApi violationCommentsToGitHubApi;
    private final ViolationsLogger violationsLogger;

    public GitHubCommentsProvider(ViolationsLogger violationsLogger, ViolationCommentsToGitHubApi violationCommentsToGitHubApi) {
        this.violationsLogger = violationsLogger;
        GitHubClientTestable gitHubClient = GitHubCommentsProvider.getGitHubClient(violationCommentsToGitHubApi.getGitHubUrl());
        if (violationCommentsToGitHubApi.getOAuth2Token() != null) {
            gitHubClient.setOAuth2Token(violationCommentsToGitHubApi.getOAuth2Token());
        } else if (violationCommentsToGitHubApi.getUsername() != null && violationCommentsToGitHubApi.getPassword() != null) {
            gitHubClient.setCredentials(violationCommentsToGitHubApi.getUsername(), violationCommentsToGitHubApi.getPassword());
        }
        this.repository = new RepositoryId(violationCommentsToGitHubApi.getRepositoryOwner(), violationCommentsToGitHubApi.getRepositoryName());
        this.pullRequestService = new PullRequestService((GitHubClient)gitHubClient);
        this.issueSerivce = new IssueService((GitHubClient)gitHubClient);
        List commits = null;
        try {
            commits = this.pullRequestService.getCommits((IRepositoryIdProvider)this.repository, violationCommentsToGitHubApi.getPullRequestId());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.pullRequestCommit = ((RepositoryCommit)commits.get(commits.size() - 1)).getSha();
        this.violationCommentsToGitHubApi = violationCommentsToGitHubApi;
    }

    static GitHubClientTestable getGitHubClient(String gitHubUrl) {
        try {
            URL url = new URL(gitHubUrl);
            String hostname = url.getHost();
            if ("github.com".equals(hostname) || "gist.github.com".equals(hostname)) {
                hostname = "api.github.com";
            }
            int port = url.getPort();
            String scheme = url.getProtocol();
            return new GitHubClientTestable(hostname, port, scheme);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void createComment(String comment) {
        try {
            this.issueSerivce.createComment((IRepositoryIdProvider)this.repository, this.violationCommentsToGitHubApi.getPullRequestId(), comment);
        }
        catch (IOException e) {
            this.violationsLogger.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
    }

    public void createSingleFileComment(ChangedFile file, Integer line, String comment) {
        String patchString = (String)file.getSpecifics().get(0);
        Optional lineToCommentOpt = new PatchParser(patchString).findLineInDiff(line.intValue());
        Integer lineToComment = lineToCommentOpt.orElse(1);
        try {
            CommitComment commitComment = new CommitComment();
            commitComment.setBody(comment);
            commitComment.setPath(file.getFilename());
            commitComment.setCommitId(this.pullRequestCommit);
            commitComment.setPosition(lineToComment.intValue());
            this.pullRequestService.createComment((IRepositoryIdProvider)this.repository, this.violationCommentsToGitHubApi.getPullRequestId(), commitComment);
        }
        catch (IOException e) {
            this.violationsLogger.log(Level.SEVERE, "File: \"" + file + "\" \nLine: \"" + line + "\" \nPosition: \"" + lineToComment + "\" \nComment: \"" + comment + "\"", (Throwable)e);
        }
    }

    public List<se.bjurr.violations.comments.lib.model.Comment> getComments() {
        ArrayList<se.bjurr.violations.comments.lib.model.Comment> comments = new ArrayList<se.bjurr.violations.comments.lib.model.Comment>();
        try {
            ArrayList specifics = new ArrayList();
            for (CommitComment commitComment : this.pullRequestService.getComments((IRepositoryIdProvider)this.repository, this.violationCommentsToGitHubApi.getPullRequestId())) {
                comments.add(new se.bjurr.violations.comments.lib.model.Comment(Long.toString(commitComment.getId()), commitComment.getBody(), TYPE_DIFF, specifics));
            }
            for (Comment comment : this.issueSerivce.getComments((IRepositoryIdProvider)this.repository, this.violationCommentsToGitHubApi.getPullRequestId())) {
                comments.add(new se.bjurr.violations.comments.lib.model.Comment(Long.toString(comment.getId()), comment.getBody(), TYPE_PR, specifics));
            }
        }
        catch (Exception e) {
            this.violationsLogger.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return comments;
    }

    public List<ChangedFile> getFiles() {
        ArrayList<ChangedFile> changedFiles = new ArrayList<ChangedFile>();
        try {
            List files = this.pullRequestService.getFiles((IRepositoryIdProvider)this.repository, this.violationCommentsToGitHubApi.getPullRequestId());
            for (CommitFile commitFile : files) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(commitFile.getPatch());
                changedFiles.add(new ChangedFile(commitFile.getFilename(), list));
            }
        }
        catch (IOException e) {
            this.violationsLogger.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return changedFiles;
    }

    public void removeComments(List<se.bjurr.violations.comments.lib.model.Comment> comments) {
        for (se.bjurr.violations.comments.lib.model.Comment comment : comments) {
            try {
                Long commentId = Long.valueOf(comment.getIdentifier());
                if (comment.getType().equals(TYPE_DIFF)) {
                    this.pullRequestService.deleteComment((IRepositoryIdProvider)this.repository, commentId.longValue());
                    continue;
                }
                this.issueSerivce.deleteComment((IRepositoryIdProvider)this.repository, commentId.longValue());
            }
            catch (Throwable e) {
                this.violationsLogger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public boolean shouldComment(ChangedFile changedFile, Integer line) {
        String patchString = (String)changedFile.getSpecifics().get(0);
        boolean lineChanged = new PatchParser(patchString).isLineInDiff(line);
        boolean commentOnlyChangedContent = this.violationCommentsToGitHubApi.getCommentOnlyChangedContent();
        return !commentOnlyChangedContent || lineChanged;
    }

    public boolean shouldCreateCommentWithAllSingleFileComments() {
        return this.violationCommentsToGitHubApi.getCreateCommentWithAllSingleFileComments();
    }

    public boolean shouldCreateSingleFileComment() {
        return this.violationCommentsToGitHubApi.getCreateSingleFileComments();
    }

    public boolean shouldKeepOldComments() {
        return this.violationCommentsToGitHubApi.getKeepOldComments();
    }

    public boolean shouldCommentOnlyChangedFiles() {
        return this.violationCommentsToGitHubApi.getCommentOnlyChangedFiles();
    }

    public Optional<String> findCommentTemplate() {
        return this.violationCommentsToGitHubApi.findCommentTemplate();
    }

    public Integer getMaxNumberOfViolations() {
        return this.violationCommentsToGitHubApi.getMaxNumberOfViolations();
    }

    public Integer getMaxCommentSize() {
        return this.violationCommentsToGitHubApi.getMaxCommentSize();
    }
}

