/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.content.Intent;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.hardware.usb.UsbPort;
import android.hardware.usb.UsbPortStatus;
import android.os.ParcelFileDescriptor;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.ForType;

@Implements(value=UsbManager.class, looseSignatures=true)
public class ShadowUsbManager {
    @RealObject
    private UsbManager realUsbManager;
    private final HashMap<String, List<UsbDevice>> grantedPermissions = new HashMap();
    private final HashMap<String, UsbDevice> usbDevices = new HashMap();
    private final HashMap<String, UsbPort> usbPorts = new HashMap();
    private final HashMap<UsbPort, UsbPortStatus> usbPortStatuses = new HashMap();
    private UsbAccessory attachedUsbAccessory = null;

    @Implementation
    protected boolean hasPermission(UsbDevice device) {
        return this.hasPermissionForPackage(device, RuntimeEnvironment.getApplication().getPackageName());
    }

    public boolean hasPermissionForPackage(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = this.grantedPermissions.get(packageName);
        return usbDevices != null && usbDevices.contains(device);
    }

    @Implementation(minSdk=24)
    @HiddenApi
    protected void grantPermission(UsbDevice device) {
        this.grantPermission(device, RuntimeEnvironment.getApplication().getPackageName());
    }

    @Implementation(minSdk=25)
    @HiddenApi
    protected void grantPermission(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = this.grantedPermissions.get(packageName);
        if (usbDevices == null) {
            usbDevices = new ArrayList<UsbDevice>();
            this.grantedPermissions.put(packageName, usbDevices);
        }
        usbDevices.add(device);
    }

    public void revokePermission(UsbDevice device, String packageName) {
        List<UsbDevice> usbDevices = this.grantedPermissions.get(packageName);
        if (usbDevices != null) {
            usbDevices.remove(device);
        }
    }

    @Implementation
    protected HashMap<String, UsbDevice> getDeviceList() {
        return new HashMap<String, UsbDevice>(this.usbDevices);
    }

    @Implementation
    protected UsbAccessory[] getAccessoryList() {
        if (this.attachedUsbAccessory == null) {
            return null;
        }
        return new UsbAccessory[]{this.attachedUsbAccessory};
    }

    public void setAttachedUsbAccessory(UsbAccessory usbAccessory) {
        this.attachedUsbAccessory = usbAccessory;
    }

    public void addOrUpdateUsbDevice(UsbDevice usbDevice, boolean hasPermission) {
        Preconditions.checkNotNull((Object)usbDevice);
        Preconditions.checkNotNull((Object)usbDevice.getDeviceName());
        this.usbDevices.put(usbDevice.getDeviceName(), usbDevice);
        if (hasPermission) {
            this.grantPermission(usbDevice);
        } else {
            this.revokePermission(usbDevice, RuntimeEnvironment.getApplication().getPackageName());
        }
    }

    public void removeUsbDevice(UsbDevice usbDevice) {
        Preconditions.checkNotNull((Object)usbDevice);
        this.usbDevices.remove(usbDevice.getDeviceName());
        this.revokePermission(usbDevice, RuntimeEnvironment.getApplication().getPackageName());
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected Object getPorts() {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return new ArrayList<UsbPort>(this.usbPortStatuses.keySet());
        }
        return this.usbPortStatuses.keySet().toArray(new UsbPort[this.usbPortStatuses.size()]);
    }

    public void clearPorts() {
        this.usbPorts.clear();
        this.usbPortStatuses.clear();
    }

    public void addPort(String portId) {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            this.addPort(portId, 3, 2, 2, 0);
            return;
        }
        UsbPort usbPort = (UsbPort)ReflectionHelpers.callConstructor(UsbPort.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)portId), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)((Integer)ReflectionHelpers.getStaticField(UsbPort.class, (String)"MODE_DUAL")))});
        this.usbPorts.put(portId, usbPort);
        this.usbPortStatuses.put(usbPort, (UsbPortStatus)ShadowUsbManager.createUsbPortStatus((Integer)ReflectionHelpers.getStaticField(UsbPort.class, (String)"MODE_DUAL"), (Integer)ReflectionHelpers.getStaticField(UsbPort.class, (String)"POWER_ROLE_SINK"), (Integer)ReflectionHelpers.getStaticField(UsbPort.class, (String)"DATA_ROLE_DEVICE"), 0));
    }

    @TargetApi(value=29)
    public void addPort(String portId, int statusCurrentMode, int statusCurrentPowerRole, int statusCurrentDataRole, int statusSupportedRoleCombinations) {
        Preconditions.checkState((RuntimeEnvironment.getApiLevel() >= 29 ? 1 : 0) != 0);
        UsbPort usbPort = (UsbPort)ShadowUsbManager.createUsbPort(this.realUsbManager, portId, statusCurrentMode);
        this.usbPorts.put(portId, usbPort);
        this.usbPortStatuses.put(usbPort, (UsbPortStatus)ShadowUsbManager.createUsbPortStatus(statusCurrentMode, statusCurrentPowerRole, statusCurrentDataRole, statusSupportedRoleCombinations));
    }

    public Object getPortStatus(String portId) {
        return this.usbPortStatuses.get(this.usbPorts.get(portId));
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected Object getPortStatus(Object port) {
        return this.usbPortStatuses.get(port);
    }

    @Implementation(minSdk=23)
    @HiddenApi
    protected void setPortRoles(Object port, Object powerRole, Object dataRole) {
        UsbPortStatus status = this.usbPortStatuses.get(port);
        this.usbPortStatuses.put((UsbPort)port, (UsbPortStatus)ShadowUsbManager.createUsbPortStatus(status.getCurrentMode(), (Integer)powerRole, (Integer)dataRole, status.getSupportedRoleCombinations()));
        RuntimeEnvironment.getApplication().sendBroadcast(new Intent("android.hardware.usb.action.USB_PORT_CHANGED"));
    }

    @Implementation
    protected ParcelFileDescriptor openAccessory(UsbAccessory accessory) {
        try {
            File tmpUsbDir = RuntimeEnvironment.getTempDirectory().createIfNotExists("usb-accessory").toFile();
            return ParcelFileDescriptor.open((File)new File(tmpUsbDir, "usb-accessory-file"), (int)0x30000000);
        }
        catch (FileNotFoundException error) {
            throw new RuntimeException("Error shadowing openAccessory", error);
        }
    }

    private static Object createUsbPortStatus(int currentMode, int currentPowerRole, int currentDataRole, int supportedRoleCombinations) {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return new UsbPortStatus(currentMode, currentPowerRole, currentDataRole, supportedRoleCombinations, 0, 0);
        }
        return ReflectionHelpers.callConstructor(UsbPortStatus.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)currentMode), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)currentPowerRole), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)currentDataRole), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)supportedRoleCombinations)});
    }

    private static Object createUsbPort(UsbManager usbManager, String id2, int supportedModes) {
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            return new UsbPort(usbManager, id2, supportedModes, 0, false, false);
        }
        return ReflectionHelpers.callConstructor(UsbPort.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(UsbManager.class, (Object)usbManager), ReflectionHelpers.ClassParameter.from(String.class, (Object)id2), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)supportedModes)});
    }

    @ForType(value=UsbManager.class)
    public static interface _UsbManagerQ_ {
        public List<UsbPort> getPorts();
    }

    @ForType(value=UsbManager.class)
    public static interface _UsbManager_ {
        public UsbPort[] getPorts();

        public UsbPortStatus getPortStatus(UsbPort var1);

        public void setPortRoles(UsbPort var1, int var2, int var3);
    }
}

