/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.app.time.ExternalTimeSuggestion;
import android.app.time.TimeManager;
import android.app.time.TimeZoneCapabilities;
import android.app.time.TimeZoneCapabilitiesAndConfig;
import android.app.time.TimeZoneConfiguration;
import android.os.UserHandle;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=TimeManager.class, minSdk=31, isInAndroidSdk=false)
public class ShadowTimeManager {
    public static final String CONFIGURE_GEO_DETECTION_CAPABILITY = "configure_geo_detection_capability";
    private TimeZoneCapabilities timeZoneCapabilities = new TimeZoneCapabilities.Builder(UserHandle.CURRENT).setConfigureAutoDetectionEnabledCapability(40).setConfigureGeoDetectionEnabledCapability(40).setSuggestManualTimeZoneCapability(40).build();
    private TimeZoneConfiguration timeZoneConfiguration;

    public void setCapabilityState(String capability, int value) {
        TimeZoneCapabilities.Builder builder = new TimeZoneCapabilities.Builder(this.timeZoneCapabilities);
        switch (capability) {
            case "configure_geo_detection_capability": {
                builder.setConfigureGeoDetectionEnabledCapability(value);
                break;
            }
            default: {
                String string = String.valueOf(capability);
                throw new IllegalArgumentException(string.length() != 0 ? "Unrecognized capability=".concat(string) : new String("Unrecognized capability="));
            }
        }
        this.timeZoneCapabilities = builder.build();
    }

    @Implementation
    @SystemApi
    protected TimeZoneCapabilitiesAndConfig getTimeZoneCapabilitiesAndConfig() {
        Objects.requireNonNull(this.timeZoneConfiguration, "timeZoneConfiguration was not set");
        return new TimeZoneCapabilitiesAndConfig(this.timeZoneCapabilities, this.timeZoneConfiguration);
    }

    @Implementation
    @SystemApi
    protected boolean updateTimeZoneConfiguration(TimeZoneConfiguration configuration) {
        this.timeZoneConfiguration = configuration;
        return true;
    }

    @Implementation
    protected void addTimeZoneDetectorListener(Executor executor, TimeManager.TimeZoneDetectorListener listener) {
    }

    @Implementation
    protected void removeTimeZoneDetectorListener(TimeManager.TimeZoneDetectorListener listener) {
    }

    @Implementation
    protected void suggestExternalTime(ExternalTimeSuggestion timeSuggestion) {
    }
}

