/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.ParcelFileDescriptor;
import android.util.AttributeSet;
import android.util.TypedValue;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.Plural;
import org.robolectric.res.PluralRules;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowLegacyAssetManager;
import org.robolectric.shadows.ShadowResources;
import org.robolectric.shadows.ShadowResourcesImpl;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ResourcesImpl.class, isInAndroidSdk=false, minSdk=24, shadowPicker=ShadowResourcesImpl.Picker.class)
public class ShadowLegacyResourcesImpl
extends ShadowResourcesImpl {
    @RealObject
    private ResourcesImpl realResourcesImpl;

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.useLegacyResources()) {
            ShadowResourcesImpl.reset();
        }
    }

    @Implementation(maxSdk=23)
    public String getQuantityString(int id2, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        String raw = this.getQuantityString(id2, quantity);
        return String.format(Locale.ENGLISH, raw, formatArgs);
    }

    @Implementation(maxSdk=23)
    public String getQuantityString(int resId, int quantity) throws Resources.NotFoundException {
        ShadowLegacyAssetManager shadowAssetManager = ShadowAssetManager.legacyShadowOf(this.realResourcesImpl.getAssets());
        TypedResource typedResource = shadowAssetManager.getResourceTable().getValue(resId, shadowAssetManager.config);
        if (typedResource != null && typedResource instanceof PluralRules) {
            PluralRules pluralRules = (PluralRules)typedResource;
            Plural plural = pluralRules.find(quantity);
            if (plural == null) {
                return null;
            }
            TypedResource resolvedTypedResource = shadowAssetManager.resolve(new TypedResource((Object)plural.getString(), ResType.CHAR_SEQUENCE, pluralRules.getXmlContext()), shadowAssetManager.config, resId);
            return resolvedTypedResource == null ? null : resolvedTypedResource.asString();
        }
        return null;
    }

    @Implementation(maxSdk=23)
    public InputStream openRawResource(int id2) throws Resources.NotFoundException {
        ShadowLegacyAssetManager shadowAssetManager = ShadowAssetManager.legacyShadowOf(this.realResourcesImpl.getAssets());
        ResourceTable resourceTable = shadowAssetManager.getResourceTable();
        InputStream inputStream = resourceTable.getRawValue(id2, shadowAssetManager.config);
        if (inputStream == null) {
            throw this.newNotFoundException(id2);
        }
        return inputStream;
    }

    @Implementation(maxSdk=23)
    public AssetFileDescriptor openRawResourceFd(int id2) throws Resources.NotFoundException {
        InputStream inputStream = this.openRawResource(id2);
        if (!(inputStream instanceof FileInputStream)) {
            return null;
        }
        FileInputStream fis = (FileInputStream)inputStream;
        try {
            return new AssetFileDescriptor(ParcelFileDescriptor.dup((FileDescriptor)fis.getFD()), 0L, fis.getChannel().size());
        }
        catch (IOException e) {
            throw this.newNotFoundException(id2);
        }
    }

    private Resources.NotFoundException newNotFoundException(int id2) {
        ResourceTable resourceTable = ShadowAssetManager.legacyShadowOf(this.realResourcesImpl.getAssets()).getResourceTable();
        ResName resName = resourceTable.getResName(id2);
        if (resName == null) {
            String string = String.valueOf(Integer.toHexString(id2));
            return new Resources.NotFoundException(string.length() != 0 ? "resource ID #0x".concat(string) : new String("resource ID #0x"));
        }
        return new Resources.NotFoundException(resName.getFullyQualifiedName());
    }

    @HiddenApi
    @Implementation(maxSdk=23)
    public XmlResourceParser loadXmlResourceParser(int resId, String type) throws Resources.NotFoundException {
        ShadowLegacyAssetManager shadowAssetManager = ShadowAssetManager.legacyShadowOf(this.realResourcesImpl.getAssets());
        return shadowAssetManager.loadXmlResourceParser(resId, type);
    }

    @HiddenApi
    @Implementation
    public XmlResourceParser loadXmlResourceParser(String file, int id2, int assetCookie, String type) throws Resources.NotFoundException {
        return this.loadXmlResourceParser(id2, type);
    }

    @Implementation(maxSdk=25)
    public Drawable loadDrawable(Resources wrapper, TypedValue value, int id2, Resources.Theme theme, boolean useCache) throws Resources.NotFoundException {
        Drawable drawable = ((ResourcesImplReflector)Reflector.reflector(ResourcesImplReflector.class, (Object)this.realResourcesImpl)).loadDrawable(wrapper, value, id2, theme, useCache);
        ShadowResources.setCreatedFromResId(wrapper, id2, drawable);
        return drawable;
    }

    @Implementation(minSdk=26)
    public Drawable loadDrawable(Resources wrapper, TypedValue value, int id2, int density, Resources.Theme theme) {
        Drawable drawable = ((ResourcesImplReflector)Reflector.reflector(ResourcesImplReflector.class, (Object)this.realResourcesImpl)).loadDrawable(wrapper, value, id2, density, theme);
        ShadowResources.setCreatedFromResId(wrapper, id2, drawable);
        return drawable;
    }

    @ForType(value=ResourcesImpl.class)
    static interface ResourcesImplReflector {
        @Direct
        public Drawable loadDrawable(Resources var1, TypedValue var2, int var3, Resources.Theme var4, boolean var5);

        @Direct
        public Drawable loadDrawable(Resources var1, TypedValue var2, int var3, int var4, Resources.Theme var5);
    }

    @Implements(value=ResourcesImpl.ThemeImpl.class, minSdk=24, isInAndroidSdk=false, shadowPicker=ShadowResourcesImpl.ShadowThemeImpl.Picker.class)
    public static class ShadowLegacyThemeImpl
    extends ShadowResourcesImpl.ShadowThemeImpl {
        @RealObject
        ResourcesImpl.ThemeImpl realThemeImpl;

        @Implementation
        public TypedArray obtainStyledAttributes(Resources.Theme wrapper, AttributeSet set, int[] attrs, int defStyleAttr, int defStyleRes) {
            Resources resources = wrapper.getResources();
            AssetManager assets = resources.getAssets();
            return ShadowAssetManager.legacyShadowOf(assets).attrsToTypedArray(resources, set, attrs, defStyleAttr, this.getNativePtr(), defStyleRes);
        }

        public long getNativePtr() {
            return (Long)ReflectionHelpers.getField((Object)this.realThemeImpl, (String)"mTheme");
        }
    }
}

