/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.bytecode;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;

class TypeMapper {
    private final Map<String, String> classesToRemap;

    public TypeMapper(Map<String, String> classNameToClassNameMap) {
        this.classesToRemap = TypeMapper.convertToSlashes(classNameToClassNameMap);
    }

    private static Map<String, String> convertToSlashes(Map<String, String> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = TypeMapper.internalize(entry.getKey());
            String value = TypeMapper.internalize(entry.getValue());
            newMap.put(key, value);
            newMap.put(new StringBuilder(2 + String.valueOf(key).length()).append("L").append(key).append(";").toString(), new StringBuilder(2 + String.valueOf(value).length()).append("L").append(value).append(";").toString());
        }
        return newMap;
    }

    private static String internalize(String className) {
        return className.replace('.', '/');
    }

    String mappedTypeName(String internalName) {
        String remappedInternalName = this.classesToRemap.get(internalName);
        if (remappedInternalName != null) {
            return remappedInternalName;
        }
        return internalName;
    }

    Type mappedType(Type type) {
        String internalName = type.getInternalName();
        String remappedInternalName = this.classesToRemap.get(internalName);
        if (remappedInternalName != null) {
            return Type.getObjectType((String)remappedInternalName);
        }
        return type;
    }

    String remapParams(String desc) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (Type type : Type.getArgumentTypes((String)desc)) {
            buf.append(this.remapParamType(type));
        }
        buf.append(")");
        buf.append(this.remapParamType(Type.getReturnType((String)desc)));
        return buf.toString();
    }

    String remapParamType(String desc) {
        return this.remapParamType(Type.getType((String)desc));
    }

    private String remapParamType(Type type) {
        switch (type.getSort()) {
            case 9: {
                String internalName = type.getInternalName();
                int count = 0;
                while (internalName.charAt(count) == '[') {
                    ++count;
                }
                String remappedName = this.remapParamType(internalName.substring(count));
                if (remappedName == null) break;
                String string = String.valueOf(internalName.substring(0, count));
                String string2 = String.valueOf(remappedName);
                return Type.getObjectType((String)(string2.length() != 0 ? string.concat(string2) : new String(string))).getDescriptor();
            }
            case 10: {
                type = this.mappedType(type);
                break;
            }
        }
        return type.getDescriptor();
    }
}

