/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.interceptors;

import com.google.common.base.Throwables;
import java.io.FileDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.annotation.Nullable;
import org.robolectric.fakes.CleanerCompat;
import org.robolectric.internal.bytecode.Interceptor;
import org.robolectric.internal.bytecode.MethodRef;
import org.robolectric.internal.bytecode.MethodSignature;
import org.robolectric.util.Function;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Util;

public class AndroidInterceptors {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();

    public static Collection<Interceptor> all() {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(Arrays.asList(new LinkedHashMapEldestInterceptor(), new SystemTimeInterceptor(), new SystemArrayCopyInterceptor(), new LocaleAdjustLanguageCodeInterceptor(), new SystemLogInterceptor(), new FileDescriptorInterceptor(), new NoOpInterceptor(), new SocketInterceptor()));
        if (Util.getJavaVersion() >= 9) {
            interceptors.add(new CleanerInterceptor());
        }
        return interceptors;
    }

    public static class SocketInterceptor
    extends Interceptor {
        public SocketInterceptor() {
            super(new MethodRef(Socket.class, "getFileDescriptor$"));
        }

        @Nullable
        static FileDescriptor getFileDescriptor(Socket socket) {
            return null;
        }

        @Override
        public Function<Object, Object> handle(MethodSignature methodSignature) {
            return new Function<Object, Object>(this){

                @Override
                public Object call(Class<?> theClass, Object value, Object[] params) {
                    return SocketInterceptor.getFileDescriptor((Socket)value);
                }
            };
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            return lookup.findStatic(this.getClass(), "getFileDescriptor", MethodType.methodType(FileDescriptor.class, Socket.class));
        }
    }

    public static class NoOpInterceptor
    extends Interceptor {
        public NoOpInterceptor() {
            super(new MethodRef("java.lang.System", "loadLibrary"), new MethodRef("android.os.StrictMode", "trackActivity"), new MethodRef("android.os.StrictMode", "incrementExpectedActivityCount"), new MethodRef("android.util.LocaleUtil", "getLayoutDirectionFromLocale"), new MethodRef("android.view.FallbackEventHandler", "*"), new MethodRef("android.view.IWindowSession", "*"));
        }

        @Override
        public Function<Object, Object> handle(MethodSignature methodSignature) {
            return NoOpInterceptor.returnDefaultValue(methodSignature);
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            MethodHandle nothing = MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE));
            if (type.parameterCount() != 0) {
                return MethodHandles.dropArguments(nothing, 0, type.parameterArray());
            }
            return nothing;
        }
    }

    public static class CleanerInterceptor
    extends Interceptor {
        public CleanerInterceptor() {
            super(new MethodRef("sun.misc.Cleaner", "create"), new MethodRef("sun.misc.Cleaner", "clean"));
        }

        static Object create(Object obj, Runnable action) {
            return CleanerCompat.register(obj, action);
        }

        static void clean(Object cleanable) {
            CleanerCompat.clean(cleanable);
        }

        @Override
        public Function<Object, Object> handle(MethodSignature methodSignature) {
            switch (methodSignature.methodName) {
                case "create": {
                    return (theClass, value, params) -> CleanerInterceptor.create(params[0], (Runnable)params[1]);
                }
                case "clean": {
                    return (theClass, value, params) -> {
                        CleanerInterceptor.clean(value);
                        return null;
                    };
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            switch (methodName) {
                case "create": {
                    return lookup.findStatic(this.getClass(), "create", MethodType.methodType(Object.class, Object.class, Runnable.class));
                }
                case "clean": {
                    return lookup.findStatic(this.getClass(), "clean", MethodType.methodType(Void.TYPE, Object.class));
                }
            }
            throw new IllegalStateException();
        }
    }

    public static class SystemLogInterceptor
    extends Interceptor {
        public SystemLogInterceptor() {
            super(new MethodRef(System.class.getName(), "logE"), new MethodRef(System.class.getName(), "logW"));
        }

        static void logE(Object ... params) {
            SystemLogInterceptor.log("System.logE: ", params);
        }

        static void logW(Object ... params) {
            SystemLogInterceptor.log("System.logW: ", params);
        }

        static void log(String prefix, Object ... params) {
            StringBuilder message = new StringBuilder(prefix);
            for (int i = 0; i < Math.min(2, params.length); ++i) {
                Object param = params[i];
                if (i > 0 && param instanceof Throwable) {
                    message.append('\n').append(Throwables.getStackTraceAsString((Throwable)((Throwable)param)));
                    continue;
                }
                message.append(param);
            }
            System.err.println(message);
        }

        @Override
        public Function<Object, Object> handle(MethodSignature methodSignature) {
            return (theClass, value, params) -> {
                if ("logE".equals(methodSignature.methodName)) {
                    SystemLogInterceptor.logE(params);
                } else if ("logW".equals(methodSignature.methodName)) {
                    SystemLogInterceptor.logW(params);
                }
                return null;
            };
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            return lookup.findStatic(this.getClass(), methodName, MethodType.methodType(Void.TYPE, Object[].class));
        }
    }

    public static class LocaleAdjustLanguageCodeInterceptor
    extends Interceptor {
        public LocaleAdjustLanguageCodeInterceptor() {
            super(new MethodRef(Locale.class, "adjustLanguageCode"));
        }

        static String adjustLanguageCode(String languageCode) {
            String adjusted = languageCode.toLowerCase(Locale.US);
            if (languageCode.equals("he")) {
                adjusted = "iw";
            } else if (languageCode.equals("id")) {
                adjusted = "in";
            } else if (languageCode.equals("yi")) {
                adjusted = "ji";
            }
            return adjusted;
        }

        @Override
        public Function<Object, Object> handle(MethodSignature methodSignature) {
            return new Function<Object, Object>(this){

                @Override
                public Object call(Class<?> theClass, Object value, Object[] params) {
                    return LocaleAdjustLanguageCodeInterceptor.adjustLanguageCode((String)params[0]);
                }
            };
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            return lookup.findStatic(this.getClass(), "adjustLanguageCode", MethodType.methodType(String.class, String.class));
        }
    }

    public static class SystemArrayCopyInterceptor
    extends Interceptor {
        public SystemArrayCopyInterceptor() {
            super(new MethodRef(System.class, "arraycopy"));
        }

        @Override
        public Function<Object, Object> handle(MethodSignature methodSignature) {
            return new Function<Object, Object>(this){

                @Override
                public Object call(Class<?> theClass, Object value, Object[] params) {
                    System.arraycopy(params[0], (Integer)params[1], params[2], (Integer)params[3], (Integer)params[4]);
                    return null;
                }
            };
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            return lookup.findStatic(System.class, "arraycopy", MethodType.methodType(Void.TYPE, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE));
        }
    }

    public static class SystemTimeInterceptor
    extends Interceptor {
        public SystemTimeInterceptor() {
            super(new MethodRef(System.class, "nanoTime"), new MethodRef(System.class, "currentTimeMillis"));
        }

        @Override
        public Function<Object, Object> handle(final MethodSignature methodSignature) {
            return new Function<Object, Object>(this){

                @Override
                public Object call(Class<?> theClass, Object value, Object[] params) {
                    ClassLoader cl = theClass.getClassLoader();
                    try {
                        Class<?> shadowSystemClass = cl.loadClass("org.robolectric.shadows.ShadowSystem");
                        return ReflectionHelpers.callStaticMethod(shadowSystemClass, (String)methodSignature.methodName, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            Class<?> shadowSystemClass;
            try {
                shadowSystemClass = this.getClass().getClassLoader().loadClass("org.robolectric.shadows.ShadowSystem");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            switch (methodName) {
                case "nanoTime": {
                    return lookup.findStatic(shadowSystemClass, "nanoTime", MethodType.methodType(Long.TYPE));
                }
                case "currentTimeMillis": {
                    return lookup.findStatic(shadowSystemClass, "currentTimeMillis", MethodType.methodType(Long.TYPE));
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    public static class LinkedHashMapEldestInterceptor
    extends Interceptor {
        public LinkedHashMapEldestInterceptor() {
            super(new MethodRef(LinkedHashMap.class, "eldest"));
        }

        @Nullable
        static Object eldest(LinkedHashMap map) {
            return map.isEmpty() ? null : map.entrySet().iterator().next();
        }

        @Override
        public Function<Object, Object> handle(MethodSignature methodSignature) {
            return new Function<Object, Object>(this){

                @Override
                public Object call(Class<?> theClass, Object value, Object[] params) {
                    return LinkedHashMapEldestInterceptor.eldest((LinkedHashMap)value);
                }
            };
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            return lookup.findStatic(this.getClass(), "eldest", MethodType.methodType(Object.class, LinkedHashMap.class));
        }
    }

    public static class FileDescriptorInterceptor
    extends Interceptor {
        public FileDescriptorInterceptor() {
            super(new MethodRef(FileDescriptor.class, "release$"));
        }

        private static void moveField(FileDescriptor out, FileDescriptor in, String fieldName, Object movedOutValue) throws ReflectiveOperationException {
            Field fieldAccessor = FileDescriptor.class.getDeclaredField(fieldName);
            fieldAccessor.setAccessible(true);
            fieldAccessor.set(out, fieldAccessor.get(in));
            fieldAccessor.set(in, movedOutValue);
        }

        static FileDescriptor release(FileDescriptor input) {
            FileDescriptor fileDescriptor = input;
            synchronized (fileDescriptor) {
                try {
                    FileDescriptor ret = new FileDescriptor();
                    FileDescriptorInterceptor.moveField(ret, input, "fd", -1);
                    FileDescriptorInterceptor.moveField(ret, input, "closed", false);
                    FileDescriptorInterceptor.moveField(ret, input, "parent", null);
                    FileDescriptorInterceptor.moveField(ret, input, "otherParents", null);
                    try {
                        FileDescriptorInterceptor.moveField(ret, input, "handle", -1);
                        FileDescriptorInterceptor.moveField(ret, input, "append", false);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        // empty catch block
                    }
                    return ret;
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        @Override
        public Function<Object, Object> handle(MethodSignature methodSignature) {
            return new Function<Object, Object>(this){

                @Override
                public Object call(Class<?> theClass, Object value, Object[] params) {
                    return FileDescriptorInterceptor.release((FileDescriptor)value);
                }
            };
        }

        @Override
        public MethodHandle getMethodHandle(String methodName, MethodType type) throws NoSuchMethodException, IllegalAccessException {
            return lookup.findStatic(this.getClass(), "release", MethodType.methodType(FileDescriptor.class, FileDescriptor.class));
        }
    }
}

