/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.Util;

public class ConfigDescription {
    public static final int SDK_CUPCAKE = 3;
    public static final int SDK_DONUT = 4;
    public static final int SDK_ECLAIR = 5;
    public static final int SDK_ECLAIR_0_1 = 6;
    public static final int SDK_ECLAIR_MR1 = 7;
    public static final int SDK_FROYO = 8;
    public static final int SDK_GINGERBREAD = 9;
    public static final int SDK_GINGERBREAD_MR1 = 10;
    public static final int SDK_HONEYCOMB = 11;
    public static final int SDK_HONEYCOMB_MR1 = 12;
    public static final int SDK_HONEYCOMB_MR2 = 13;
    public static final int SDK_ICE_CREAM_SANDWICH = 14;
    public static final int SDK_ICE_CREAM_SANDWICH_MR1 = 15;
    public static final int SDK_JELLY_BEAN = 16;
    public static final int SDK_JELLY_BEAN_MR1 = 17;
    public static final int SDK_JELLY_BEAN_MR2 = 18;
    public static final int SDK_KITKAT = 19;
    public static final int SDK_KITKAT_WATCH = 20;
    public static final int SDK_LOLLIPOP = 21;
    public static final int SDK_LOLLIPOP_MR1 = 22;
    public static final int SDK_MNC = 23;
    public static final int SDK_NOUGAT = 24;
    public static final int SDK_NOUGAT_MR1 = 25;
    public static final int SDK_O = 26;
    private static final int ACONFIGURATION_MNC_ZERO = 65535;
    private static final String kWildcardName = "any";
    private static final Pattern MCC_PATTERN = Pattern.compile("mcc([\\d]+)");
    private static final Pattern MNC_PATTERN = Pattern.compile("mnc([\\d]+)");
    private static final Pattern SMALLEST_SCREEN_WIDTH_PATTERN = Pattern.compile("^sw([0-9]+)dp");
    private static final Pattern SCREEN_WIDTH_PATTERN = Pattern.compile("^w([0-9]+)dp");
    private static final Pattern SCREEN_HEIGHT_PATTERN = Pattern.compile("^h([0-9]+)dp");
    private static final Pattern DENSITY_PATTERN = Pattern.compile("^([0-9]+)dpi");
    private static final Pattern HEIGHT_WIDTH_PATTERN = Pattern.compile("^([0-9]+)x([0-9]+)");
    private static final Pattern VERSION_QUALIFIER_PATTERN = Pattern.compile("v([0-9]+)$");

    public static boolean parse(String str, ResTable_config out) {
        return ConfigDescription.parse(str, out, true);
    }

    public static boolean parse(String str, ResTable_config out, boolean applyVersionForCompat) {
        boolean success;
        PeekingIterator part_iter = Iterators.peekingIterator(Arrays.asList(str.toLowerCase().split("-")).iterator());
        LocaleValue locale = new LocaleValue();
        boolean bl = success = !part_iter.hasNext();
        if (part_iter.hasNext() && ConfigDescription.parseMcc((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl2 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseMnc((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl3 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext()) {
            int parts_consumed = locale.initFromParts((PeekingIterator<String>)part_iter);
            if (parts_consumed < 0) {
                return false;
            }
            locale.writeTo(out);
            if (!part_iter.hasNext()) {
                boolean bl4 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseLayoutDirection((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl5 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseSmallestScreenWidthDp((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl6 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseScreenWidthDp((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl7 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseScreenHeightDp((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl8 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseScreenLayoutSize((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl9 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseScreenLayoutLong((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl10 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseScreenRound((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl11 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseWideColorGamut((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl12 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseHdr((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl13 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseOrientation((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl14 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseUiModeType((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl15 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseUiModeNight((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl16 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseDensity((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl17 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseTouchscreen((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl18 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseKeysHidden((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl19 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseKeyboard((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl20 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseNavHidden((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl21 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseNavigation((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl22 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseScreenSize((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl23 = success = !part_iter.hasNext();
            }
        }
        if (part_iter.hasNext() && ConfigDescription.parseVersion((String)part_iter.peek(), out)) {
            part_iter.next();
            if (!part_iter.hasNext()) {
                boolean bl24 = success = !part_iter.hasNext();
            }
        }
        if (!success) {
            return false;
        }
        if (out != null && applyVersionForCompat) {
            ConfigDescription.applyVersionForCompatibility(out);
        }
        return true;
    }

    private static boolean parseLayoutDirection(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFF3F | 0;
            }
            return true;
        }
        if (Objects.equals(name, "ldltr")) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFF3F | 0x40;
            }
            return true;
        }
        if (Objects.equals(name, "ldrtl")) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFF3F | 0x80;
            }
            return true;
        }
        return false;
    }

    private static boolean parseSmallestScreenWidthDp(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.smallestScreenWidthDp = 0;
            }
            return true;
        }
        Matcher matcher = SMALLEST_SCREEN_WIDTH_PATTERN.matcher(name);
        if (matcher.matches()) {
            out.smallestScreenWidthDp = Integer.parseInt(matcher.group(1));
            return true;
        }
        return false;
    }

    private static boolean parseScreenWidthDp(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.screenWidthDp = 0;
            }
            return true;
        }
        Matcher matcher = SCREEN_WIDTH_PATTERN.matcher(name);
        if (matcher.matches()) {
            out.screenWidthDp = Integer.parseInt(matcher.group(1));
            return true;
        }
        return false;
    }

    private static boolean parseScreenHeightDp(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.screenHeightDp = 0;
            }
            return true;
        }
        Matcher matcher = SCREEN_HEIGHT_PATTERN.matcher(name);
        if (matcher.matches()) {
            out.screenHeightDp = Integer.parseInt(matcher.group(1));
            return true;
        }
        return false;
    }

    private static boolean parseScreenLayoutSize(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFFF0 | 0;
            }
            return true;
        }
        if (Objects.equals(name, "small")) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFFF0 | 1;
            }
            return true;
        }
        if (Objects.equals(name, "normal")) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFFF0 | 2;
            }
            return true;
        }
        if (Objects.equals(name, "large")) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFFF0 | 3;
            }
            return true;
        }
        if (Objects.equals(name, "xlarge")) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFFF0 | 4;
            }
            return true;
        }
        return false;
    }

    static boolean parseScreenLayoutLong(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFFCF | 0;
            }
            return true;
        }
        if (Objects.equals(name, "long")) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFFCF | 0x20;
            }
            return true;
        }
        if (Objects.equals(name, "notlong")) {
            if (out != null) {
                out.screenLayout = out.screenLayout & 0xFFFFFFCF | 0x10;
            }
            return true;
        }
        return false;
    }

    private static boolean parseScreenRound(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.screenLayout2 = (byte)(out.screenLayout2 & 0xFFFFFFFC | 0);
            }
            return true;
        }
        if (Objects.equals(name, "round")) {
            if (out != null) {
                out.screenLayout2 = (byte)(out.screenLayout2 & 0xFFFFFFFC | 2);
            }
            return true;
        }
        if (Objects.equals(name, "notround")) {
            if (out != null) {
                out.screenLayout2 = (byte)(out.screenLayout2 & 0xFFFFFFFC | 1);
            }
            return true;
        }
        return false;
    }

    private static boolean parseWideColorGamut(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.colorMode = (byte)(out.colorMode & 0xFFFFFFFC | 0);
            }
            return true;
        }
        if (Objects.equals(name, "widecg")) {
            if (out != null) {
                out.colorMode = (byte)(out.colorMode & 0xFFFFFFFC | 2);
            }
            return true;
        }
        if (Objects.equals(name, "nowidecg")) {
            if (out != null) {
                out.colorMode = (byte)(out.colorMode & 0xFFFFFFFC | 1);
            }
            return true;
        }
        return false;
    }

    private static boolean parseHdr(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.colorMode = (byte)(out.colorMode & 0xFFFFFFF3 | 0);
            }
            return true;
        }
        if (Objects.equals(name, "highdr")) {
            if (out != null) {
                out.colorMode = (byte)(out.colorMode & 0xFFFFFFF3 | 8);
            }
            return true;
        }
        if (Objects.equals(name, "lowdr")) {
            if (out != null) {
                out.colorMode = (byte)(out.colorMode & 0xFFFFFFF3 | 4);
            }
            return true;
        }
        return false;
    }

    private static boolean parseOrientation(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.orientation = 0;
            }
            return true;
        }
        if (Objects.equals(name, "port")) {
            if (out != null) {
                out.orientation = 1;
            }
            return true;
        }
        if (Objects.equals(name, "land")) {
            if (out != null) {
                out.orientation = 2;
            }
            return true;
        }
        if (Objects.equals(name, "square")) {
            if (out != null) {
                out.orientation = 3;
            }
            return true;
        }
        return false;
    }

    private static boolean parseUiModeType(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFF0 | 0;
            }
            return true;
        }
        if (Objects.equals(name, "desk")) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFF0 | 2;
            }
            return true;
        }
        if (Objects.equals(name, "car")) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFF0 | 3;
            }
            return true;
        }
        if (Objects.equals(name, "television")) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFF0 | 4;
            }
            return true;
        }
        if (Objects.equals(name, "appliance")) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFF0 | 5;
            }
            return true;
        }
        if (Objects.equals(name, "watch")) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFF0 | 6;
            }
            return true;
        }
        if (Objects.equals(name, "vrheadset")) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFF0 | 7;
            }
            return true;
        }
        return false;
    }

    private static boolean parseUiModeNight(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFCF | 0;
            }
            return true;
        }
        if (Objects.equals(name, "night")) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFCF | 0x20;
            }
            return true;
        }
        if (Objects.equals(name, "notnight")) {
            if (out != null) {
                out.uiMode = out.uiMode & 0xFFFFFFCF | 0x10;
            }
            return true;
        }
        return false;
    }

    private static boolean parseDensity(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.density = 0;
            }
            return true;
        }
        if (Objects.equals(name, "anydpi")) {
            if (out != null) {
                out.density = 65534;
            }
            return true;
        }
        if (Objects.equals(name, "nodpi")) {
            if (out != null) {
                out.density = 65535;
            }
            return true;
        }
        if (Objects.equals(name, "ldpi")) {
            if (out != null) {
                out.density = 120;
            }
            return true;
        }
        if (Objects.equals(name, "mdpi")) {
            if (out != null) {
                out.density = 160;
            }
            return true;
        }
        if (Objects.equals(name, "tvdpi")) {
            if (out != null) {
                out.density = 213;
            }
            return true;
        }
        if (Objects.equals(name, "hdpi")) {
            if (out != null) {
                out.density = 240;
            }
            return true;
        }
        if (Objects.equals(name, "xhdpi")) {
            if (out != null) {
                out.density = 320;
            }
            return true;
        }
        if (Objects.equals(name, "xxhdpi")) {
            if (out != null) {
                out.density = 480;
            }
            return true;
        }
        if (Objects.equals(name, "xxxhdpi")) {
            if (out != null) {
                out.density = 640;
            }
            return true;
        }
        Matcher matcher = DENSITY_PATTERN.matcher(name);
        if (matcher.matches()) {
            out.density = Integer.parseInt(matcher.group(1));
            return true;
        }
        return false;
    }

    private static boolean parseTouchscreen(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.touchscreen = 0;
            }
            return true;
        }
        if (Objects.equals(name, "notouch")) {
            if (out != null) {
                out.touchscreen = 1;
            }
            return true;
        }
        if (Objects.equals(name, "stylus")) {
            if (out != null) {
                out.touchscreen = 2;
            }
            return true;
        }
        if (Objects.equals(name, "finger")) {
            if (out != null) {
                out.touchscreen = 3;
            }
            return true;
        }
        return false;
    }

    private static boolean parseKeysHidden(String name, ResTable_config out) {
        int mask = 0;
        int value = 0;
        if (Objects.equals(name, kWildcardName)) {
            mask = 3;
            value = 0;
        } else if (Objects.equals(name, "keysexposed")) {
            mask = 3;
            value = 1;
        } else if (Objects.equals(name, "keyshidden")) {
            mask = 3;
            value = 2;
        } else if (Objects.equals(name, "keyssoft")) {
            mask = 3;
            value = 3;
        }
        if (mask != 0) {
            if (out != null) {
                out.inputFlags = out.inputFlags & ~mask | value;
            }
            return true;
        }
        return false;
    }

    private static boolean parseKeyboard(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.keyboard = 0;
            }
            return true;
        }
        if (Objects.equals(name, "nokeys")) {
            if (out != null) {
                out.keyboard = 1;
            }
            return true;
        }
        if (Objects.equals(name, "qwerty")) {
            if (out != null) {
                out.keyboard = 2;
            }
            return true;
        }
        if (Objects.equals(name, "12key")) {
            if (out != null) {
                out.keyboard = 3;
            }
            return true;
        }
        return false;
    }

    private static boolean parseNavHidden(String name, ResTable_config out) {
        int mask = 0;
        int value = 0;
        if (Objects.equals(name, kWildcardName)) {
            mask = 12;
            value = 0;
        } else if (Objects.equals(name, "navexposed")) {
            mask = 12;
            value = 4;
        } else if (Objects.equals(name, "navhidden")) {
            mask = 12;
            value = 8;
        }
        if (mask != 0) {
            if (out != null) {
                out.inputFlags = out.inputFlags & ~mask | value;
            }
            return true;
        }
        return false;
    }

    private static boolean parseNavigation(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.navigation = 0;
            }
            return true;
        }
        if (Objects.equals(name, "nonav")) {
            if (out != null) {
                out.navigation = 1;
            }
            return true;
        }
        if (Objects.equals(name, "dpad")) {
            if (out != null) {
                out.navigation = 2;
            }
            return true;
        }
        if (Objects.equals(name, "trackball")) {
            if (out != null) {
                out.navigation = 3;
            }
            return true;
        }
        if (Objects.equals(name, "wheel")) {
            if (out != null) {
                out.navigation = 4;
            }
            return true;
        }
        return false;
    }

    private static boolean parseScreenSize(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.screenWidth = 0;
                out.screenHeight = 0;
            }
            return true;
        }
        Matcher matcher = HEIGHT_WIDTH_PATTERN.matcher(name);
        if (matcher.matches()) {
            int h;
            int w = Integer.parseInt(matcher.group(1));
            if (w < (h = Integer.parseInt(matcher.group(2)))) {
                return false;
            }
            out.screenWidth = w;
            out.screenHeight = h;
            return true;
        }
        return false;
    }

    private static boolean parseVersion(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.sdkVersion = 0;
                out.minorVersion = 0;
            }
            return true;
        }
        Matcher matcher = VERSION_QUALIFIER_PATTERN.matcher(name);
        if (matcher.matches()) {
            out.sdkVersion = Integer.parseInt(matcher.group(1));
            out.minorVersion = 0;
            return true;
        }
        return false;
    }

    private static boolean parseMnc(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.mnc = 0;
            }
            return true;
        }
        Matcher matcher = MNC_PATTERN.matcher(name);
        if (matcher.matches()) {
            out.mnc = Integer.parseInt(matcher.group(1));
            if (out.mnc == 0) {
                out.mnc = 65535;
            }
            return true;
        }
        return false;
    }

    private static boolean parseMcc(String name, ResTable_config out) {
        if (Objects.equals(name, kWildcardName)) {
            if (out != null) {
                out.mcc = 0;
            }
            return true;
        }
        Matcher matcher = MCC_PATTERN.matcher(name);
        if (matcher.matches()) {
            out.mcc = Integer.parseInt(matcher.group(1));
            return true;
        }
        return false;
    }

    private static void applyVersionForCompatibility(ResTable_config config) {
        if (config == null) {
            return;
        }
        int min_sdk = 0;
        if ((config.uiMode & 0xF) == 7 || (config.colorMode & 3) != 0 || (config.colorMode & 0xC) != 0) {
            min_sdk = 26;
        } else if (Util.isTruthy(config.screenLayout2 & 3)) {
            min_sdk = 23;
        } else if (config.density == 65534) {
            min_sdk = 21;
        } else if (config.smallestScreenWidthDp != 0 || config.screenWidthDp != 0 || config.screenHeightDp != 0) {
            min_sdk = 13;
        } else if ((config.uiMode & 0xF) != 0 || (config.uiMode & 0x30) != 0) {
            min_sdk = 8;
        } else if ((config.screenLayout & 0xF) != 0 || (config.screenLayout & 0x30) != 0 || config.density != 0) {
            min_sdk = 4;
        }
        if (min_sdk > config.sdkVersion) {
            config.sdkVersion = min_sdk;
        }
    }

    public static class LocaleValue {
        String language;
        String region;
        String script;
        String variant;

        void set_language(String language_chars) {
            this.language = language_chars.trim().toLowerCase();
        }

        void set_region(String region_chars) {
            this.region = region_chars.trim().toUpperCase();
        }

        void set_script(String script_chars) {
            String string = String.valueOf(String.valueOf(Character.toUpperCase(script_chars.charAt(0))));
            String string2 = String.valueOf(script_chars.substring(1).toLowerCase());
            this.script = string2.length() != 0 ? string.concat(string2) : new String(string);
        }

        void set_variant(String variant_chars) {
            this.variant = variant_chars.trim();
        }

        static boolean is_alpha(String str) {
            for (int i = 0; i < str.length(); ++i) {
                if (Character.isAlphabetic(str.charAt(i))) continue;
                return false;
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        int initFromParts(PeekingIterator<String> iter) {
            block21: {
                block17: {
                    block19: {
                        block20: {
                            block18: {
                                part = (String)iter.peek();
                                if (!part.startsWith("b+")) break block17;
                                subtags = part.substring(2).toLowerCase().split("\\+", 0);
                                if (subtags.length != 1) break block18;
                                this.set_language(subtags[0]);
                                break block19;
                            }
                            if (subtags.length != 2) break block20;
                            this.set_language(subtags[0]);
                            switch (subtags[1].length()) {
                                case 2: 
                                case 3: {
                                    this.set_region(subtags[1]);
                                    break block19;
                                }
                                case 4: {
                                    if ('0' <= subtags[1].charAt(0) && subtags[1].charAt(0) <= '9') ** GOTO lbl18
                                    this.set_script(subtags[1]);
                                    break block19;
                                }
lbl18:
                                // 2 sources

                                case 5: 
                                case 6: 
                                case 7: 
                                case 8: {
                                    this.set_variant(subtags[1]);
                                    break block19;
                                }
                                default: {
                                    return -1;
                                }
                            }
                        }
                        if (subtags.length == 3) {
                            this.set_language(subtags[0]);
                            if (subtags[1].length() == 4) {
                                this.set_script(subtags[1]);
                            } else if (subtags[1].length() == 2 || subtags[1].length() == 3) {
                                this.set_region(subtags[1]);
                            } else {
                                return -1;
                            }
                            if (subtags[2].length() >= 4) {
                                this.set_variant(subtags[2]);
                            } else {
                                this.set_region(subtags[2]);
                            }
                        } else if (subtags.length == 4) {
                            this.set_language(subtags[0]);
                            this.set_script(subtags[1]);
                            this.set_region(subtags[2]);
                            this.set_variant(subtags[3]);
                        } else {
                            return -1;
                        }
                    }
                    iter.next();
                    break block21;
                }
                if ((part.length() == 2 || part.length() == 3) && LocaleValue.is_alpha(part) && !Objects.equals(part, "car")) {
                    this.set_language(part);
                    iter.next();
                    if (iter.hasNext() && (region_part = (String)iter.peek()).charAt(0) == 'r' && region_part.length() == 3) {
                        this.set_region(region_part.substring(1));
                        iter.next();
                    }
                }
            }
            return 0;
        }

        public void writeTo(ResTable_config out) {
            out.packLanguage(this.language);
            out.packRegion(this.region);
            Arrays.fill(out.localeScript, (byte)0);
            byte[] scriptBytes = this.script == null ? new byte[4] : this.script.getBytes(StandardCharsets.UTF_8);
            System.arraycopy(scriptBytes, 0, out.localeScript, 0, scriptBytes.length);
            Arrays.fill(out.localeVariant, (byte)0);
            byte[] variantBytes = this.variant == null ? new byte[8] : this.variant.getBytes(StandardCharsets.UTF_8);
            System.arraycopy(variantBytes, 0, out.localeVariant, 0, variantBytes.length);
        }
    }
}

