/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.robolectric.res.NodeHandler;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.ResType;
import org.robolectric.res.StaxLoader;
import org.robolectric.res.TextCollectingNodeHandler;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlContext;

public class StaxArrayLoader
extends StaxLoader {
    private String name;
    private List<TypedResource> items;
    private final StringBuilder buf = new StringBuilder();

    public StaxArrayLoader(PackageResourceTable resourceTable, String attrType, ResType arrayResType, final ResType scalarResType) {
        super(resourceTable, attrType, arrayResType);
        this.addHandler("item", new NodeHandler(){

            @Override
            public void onStart(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
                StaxArrayLoader.this.buf.setLength(0);
            }

            @Override
            public void onCharacters(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
                StaxArrayLoader.this.buf.append(xml.getText());
            }

            @Override
            public void onEnd(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
                ResType resType = scalarResType == null ? ResType.inferType(StaxArrayLoader.this.buf.toString()) : scalarResType;
                StaxArrayLoader.this.items.add(new TypedResource<String>(StaxArrayLoader.this.buf.toString(), resType, xmlContext));
            }

            @Override
            NodeHandler findMatchFor(XMLStreamReader xml) {
                return new TextCollectingNodeHandler(StaxArrayLoader.this.buf);
            }
        });
    }

    @Override
    public void onStart(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        this.name = xml.getAttributeValue(null, "name");
        this.items = new ArrayList<TypedResource>();
    }

    @Override
    public void onEnd(XMLStreamReader xml, XmlContext xmlContext) throws XMLStreamException {
        this.resourceTable.addResource(this.attrType, this.name, new TypedResource<List<TypedResource>>(this.items, this.resType, xmlContext));
    }
}

