/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util.statemachine;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jupnp.util.statemachine.TransitionException;

public class StateMachineInvocationHandler
implements InvocationHandler {
    private final Logger logger = Logger.getLogger(StateMachineInvocationHandler.class.getName());
    public static final String METHOD_ON_ENTRY = "onEntry";
    public static final String METHOD_ON_EXIT = "onExit";
    final Class<?> initialStateClass;
    final Map<Class<?>, Object> stateObjects = new ConcurrentHashMap();
    Object currentState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StateMachineInvocationHandler(List<Class<?>> stateClasses, Class<?> initialStateClass, Class<?>[] constructorArgumentTypes, Object[] constructorArguments) {
        this.logger.fine("Creating state machine with initial state: " + initialStateClass);
        this.initialStateClass = initialStateClass;
        for (Class<?> stateClass : stateClasses) {
            try {
                Object state = constructorArgumentTypes != null ? stateClass.getConstructor(constructorArgumentTypes).newInstance(constructorArguments) : stateClass.newInstance();
                this.logger.fine("Adding state instance: " + state.getClass().getName());
                this.stateObjects.put(stateClass, state);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("State " + stateClass.getName() + " has the wrong constructor: " + ex, ex);
            }
            catch (Exception ex) {
                throw new RuntimeException("State " + stateClass.getName() + " can't be instantiated: " + ex, ex);
            }
        }
        if (!this.stateObjects.containsKey(initialStateClass)) {
            throw new RuntimeException("Initial state not in list of states: " + initialStateClass);
        }
        this.currentState = this.stateObjects.get(initialStateClass);
        StateMachineInvocationHandler stateMachineInvocationHandler = this;
        synchronized (stateMachineInvocationHandler) {
            this.invokeEntryMethod(this.currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StateMachineInvocationHandler stateMachineInvocationHandler = this;
        synchronized (stateMachineInvocationHandler) {
            Class nextStateClass;
            block7: {
                if ("getCurrentState".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return this.currentState;
                }
                if (!"forceState".equals(method.getName()) || method.getParameterTypes().length != 1 || args.length != 1 || args[0] == null || !(args[0] instanceof Class)) break block7;
                Object forcedState = this.stateObjects.get((Class)args[0]);
                if (forcedState == null) {
                    throw new TransitionException("Can't force to invalid state: " + args[0]);
                }
                this.logger.finer("Forcing state machine into state: " + forcedState.getClass().getName());
                this.invokeExitMethod(this.currentState);
                this.currentState = forcedState;
                this.invokeEntryMethod(forcedState);
                return null;
            }
            Method signalMethod = this.getMethodOfCurrentState(method);
            this.logger.fine("Invoking signal method of current state: " + signalMethod.toString());
            Object methodReturn = signalMethod.invoke(this.currentState, args);
            if (methodReturn != null && methodReturn instanceof Class && this.stateObjects.containsKey(nextStateClass = (Class)methodReturn)) {
                this.logger.fine("Executing transition to next state: " + nextStateClass.getName());
                this.invokeExitMethod(this.currentState);
                this.currentState = this.stateObjects.get(nextStateClass);
                this.invokeEntryMethod(this.currentState);
            }
            return methodReturn;
        }
    }

    private Method getMethodOfCurrentState(Method method) {
        try {
            return this.currentState.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            throw new TransitionException("State '" + this.currentState.getClass().getName() + "' doesn't support signal '" + method.getName() + "'");
        }
    }

    private void invokeEntryMethod(Object state) {
        this.logger.fine("Trying to invoke entry method of state: " + state.getClass().getName());
        try {
            Method onEntryMethod = state.getClass().getMethod(METHOD_ON_ENTRY, new Class[0]);
            onEntryMethod.invoke(state, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            this.logger.finer("No entry method found on state: " + state.getClass().getName());
        }
        catch (Exception ex) {
            throw new TransitionException("State '" + state.getClass().getName() + "' entry method threw exception: " + ex, ex);
        }
    }

    private void invokeExitMethod(Object state) {
        this.logger.finer("Trying to invoking exit method of state: " + state.getClass().getName());
        try {
            Method onExitMethod = state.getClass().getMethod(METHOD_ON_EXIT, new Class[0]);
            onExitMethod.invoke(state, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            this.logger.finer("No exit method found on state: " + state.getClass().getName());
        }
        catch (Exception ex) {
            throw new TransitionException("State '" + state.getClass().getName() + "' exit method threw exception: " + ex, ex);
        }
    }
}

