/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.util;

import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificationViolationReporter {
    private static final SpecificationViolationReporter INSTANCE = new SpecificationViolationReporter();
    private volatile boolean enabled = true;
    private Logger logger = LoggerFactory.getLogger(SpecificationViolationReporter.class);

    private void _disableReporting() {
        this.enabled = false;
    }

    private void _enableReporting() {
        this.enabled = true;
    }

    private void _report(String format, Object ... arguments) {
        if (this.enabled) {
            this.logger.warn("{}: " + format, (Object)"UPnP specification violation", (Object)arguments);
        }
    }

    private void _report(Device<DeviceIdentity, Device, Service> device, String format, Object ... arguments) {
        if (this.enabled) {
            if (device == null) {
                this.logger.warn("{}: " + format, (Object)"UPnP specification violation", (Object)arguments);
            } else {
                this.logger.warn("{} of device '{}': " + format, new Object[]{"UPnP specification violation", device.toString(), arguments});
            }
        }
    }

    public static void disableReporting() {
        INSTANCE._disableReporting();
    }

    public static void enableReporting() {
        INSTANCE._enableReporting();
    }

    public static void report(String format, Object ... arguments) {
        INSTANCE._report(format, arguments);
    }

    public static void report(Device<DeviceIdentity, Device, Service> device, String format, Object ... arguments) {
        INSTANCE._report(device, format, arguments);
    }
}

