/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.jetty;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.jupnp.http.Headers;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpOperation;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.impl.jetty.HeaderUtil;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.AbstractStreamClient;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyStreamClientImpl
extends AbstractStreamClient<StreamClientConfigurationImpl, Request> {
    private final Logger log = LoggerFactory.getLogger(StreamClient.class);
    protected final StreamClientConfigurationImpl configuration;
    protected final HttpClient httpClient;
    protected final HttpFields defaultHttpFields = new HttpFields();

    public JettyStreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        this.httpClient = new HttpClient();
        this.httpClient.setConnectTimeout((long)((this.getConfiguration().getTimeoutSeconds() + 5) * 1000));
        this.httpClient.setMaxConnectionsPerDestination(2);
        int cpus = Runtime.getRuntime().availableProcessors();
        int maxThreads = 5 * cpus;
        QueuedThreadPool queuedThreadPool = this.createThreadPool("jupnp-jetty-client", 5, maxThreads, 60000);
        this.httpClient.setExecutor((Executor)queuedThreadPool);
        if (this.getConfiguration().getSocketBufferSize() != -1) {
            this.httpClient.setRequestBufferSize(this.getConfiguration().getSocketBufferSize());
            this.httpClient.setResponseBufferSize(this.getConfiguration().getSocketBufferSize());
        }
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            this.log.error("Failed to instantiate HTTP client", (Throwable)e);
            throw new InitializationException("Failed to instantiate HTTP client", e);
        }
    }

    @Override
    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    protected Request createRequest(StreamRequestMessage requestMessage) {
        Request request;
        UpnpRequest upnpRequest = (UpnpRequest)requestMessage.getOperation();
        this.log.trace("Creating HTTP request. URI: '{}' method: '{}'", (Object)upnpRequest.getURI(), (Object)upnpRequest.getMethod());
        switch (upnpRequest.getMethod()) {
            case GET: 
            case POST: 
            case NOTIFY: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                request = this.httpClient.newRequest(upnpRequest.getURI()).method(upnpRequest.getHttpMethodName());
                break;
            }
            default: {
                throw new RuntimeException("Unknown HTTP method: " + upnpRequest.getHttpMethodName());
            }
        }
        switch (upnpRequest.getMethod()) {
            case POST: 
            case NOTIFY: {
                request.content((ContentProvider)this.createContentProvider(requestMessage));
            }
        }
        request.getHeaders().add(this.defaultHttpFields);
        if (((UpnpRequest)requestMessage.getOperation()).getHttpMinorVersion() == 0) {
            request.version(HttpVersion.HTTP_1_0);
        } else {
            request.version(HttpVersion.HTTP_1_1);
            request.header(HttpHeader.CONNECTION, "close");
        }
        if (!requestMessage.getHeaders().containsKey(UpnpHeader.Type.USER_AGENT)) {
            request.agent(this.getConfiguration().getUserAgentValue(requestMessage.getUdaMajorVersion(), requestMessage.getUdaMinorVersion()));
        }
        HeaderUtil.add(request, (Headers)requestMessage.getHeaders());
        return request;
    }

    @Override
    protected Callable<StreamResponseMessage> createCallable(final StreamRequestMessage requestMessage, final Request request) {
        return new Callable<StreamResponseMessage>(){

            @Override
            public StreamResponseMessage call() throws Exception {
                JettyStreamClientImpl.this.log.trace("Sending HTTP request: {}", (Object)requestMessage);
                try {
                    ContentResponse httpResponse = request.send();
                    JettyStreamClientImpl.this.log.trace("Received HTTP response: {}", (Object)httpResponse.getReason());
                    UpnpResponse responseOperation = new UpnpResponse(httpResponse.getStatus(), httpResponse.getReason());
                    StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
                    responseMessage.setHeaders(new UpnpHeaders(HeaderUtil.get((Response)httpResponse)));
                    byte[] bytes = httpResponse.getContent();
                    if (bytes == null || bytes.length == 0) {
                        JettyStreamClientImpl.this.log.trace("HTTP response message has no entity");
                        return responseMessage;
                    }
                    if (responseMessage.isContentTypeMissingOrText()) {
                        JettyStreamClientImpl.this.log.trace("HTTP response message contains text entity");
                    } else {
                        JettyStreamClientImpl.this.log.trace("HTTP response message contains binary entity");
                    }
                    responseMessage.setBodyCharacters(bytes);
                    return responseMessage;
                }
                catch (RuntimeException e) {
                    JettyStreamClientImpl.this.log.error("Request: {} failed", (Object)request, (Object)e);
                    throw e;
                }
            }
        };
    }

    @Override
    protected void abort(Request request) {
        request.abort((Throwable)new Exception("Request aborted by API"));
    }

    @Override
    protected boolean logExecutionException(Throwable t) {
        if (t instanceof IllegalStateException) {
            this.log.trace("Illegal state: {}", (Object)t.getMessage());
            return true;
        }
        if (t.getMessage().contains("HTTP protocol violation")) {
            SpecificationViolationReporter.report(t.getMessage(), new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.log.trace("Shutting down HTTP client connection manager/pool");
        try {
            this.httpClient.stop();
        }
        catch (Exception e) {
            this.log.info("Shutting down of HTTP client throwed exception", (Throwable)e);
        }
    }

    protected <O extends UpnpOperation> ContentProvider.Typed createContentProvider(UpnpMessage<O> upnpMessage) {
        if (upnpMessage.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
            this.log.trace("Preparing HTTP request entity as String");
            String charset = upnpMessage.getContentTypeCharset();
            return new StringContentProvider(upnpMessage.getBodyString(), charset != null ? charset : "UTF-8");
        }
        this.log.trace("Preparing HTTP request entity as byte[]");
        return new BytesContentProvider((byte[][])new byte[][]{upnpMessage.getBodyBytes()});
    }

    private QueuedThreadPool createThreadPool(String consumerName, int minThreads, int maxThreads, int keepAliveTimeout) {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(maxThreads, minThreads, keepAliveTimeout);
        queuedThreadPool.setName(consumerName);
        queuedThreadPool.setDaemon(true);
        return queuedThreadPool;
    }
}

