/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class PooledXmlProcessor {
    private final DocumentBuilderFactory documentBuilderFactory;
    private final ConcurrentLinkedQueue<DocumentBuilder> builderPool;
    private final transient Logger logger = LoggerFactory.getLogger(PooledXmlProcessor.class);

    public PooledXmlProcessor() {
        this(20);
    }

    public PooledXmlProcessor(int basePoolSize) {
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
        this.builderPool = new ConcurrentLinkedQueue();
        int i = 0;
        while (i < basePoolSize) {
            try {
                this.builderPool.add(this.documentBuilderFactory.newDocumentBuilder());
            }
            catch (ParserConfigurationException e) {
                this.logger.error("Error when invoking newDocumentBuilder():", (Throwable)e);
            }
            ++i;
        }
    }

    protected Document newDocument() throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        return this.getDocument(null, null);
    }

    protected Document readDocument(InputSource inputSource, ErrorHandler errorHandler) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        return this.getDocument(inputSource, errorHandler);
    }

    protected Document readDocument(InputSource inputSource) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        return this.getDocument(inputSource, null);
    }

    private Document getDocument(InputSource inputSource, ErrorHandler errorHandler) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.builderPool.poll();
        if (builder == null) {
            builder = this.documentBuilderFactory.newDocumentBuilder();
        }
        try {
            if (errorHandler != null) {
                builder.setErrorHandler(errorHandler);
            }
            if (inputSource != null) {
                Document document = builder.parse(inputSource);
                return document;
            }
            Document document = builder.newDocument();
            return document;
        }
        finally {
            this.returnBuilder(builder);
        }
    }

    private void returnBuilder(DocumentBuilder builder) throws FactoryConfigurationError, ParserConfigurationException {
        builder.reset();
        this.builderPool.add(builder);
    }
}

