/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.jupnp.model.ExpirationDetails;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.RegistrationException;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.registry.RegistryItem;
import org.jupnp.registry.RegistryItems;
import org.jupnp.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteItems
extends RegistryItems<RemoteDevice, RemoteGENASubscription> {
    private Logger log = LoggerFactory.getLogger(Registry.class);

    RemoteItems(RegistryImpl registry) {
        super(registry);
    }

    @Override
    void add(final RemoteDevice device) {
        if (this.update((RemoteDeviceIdentity)device.getIdentity())) {
            this.log.trace("Ignoring addition, device already registered: " + device);
            return;
        }
        Resource[] resources = this.getResources(device);
        Object object = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource deviceResource = object[n2];
            this.log.trace("Validating remote device resource; " + deviceResource);
            if (this.registry.getResource(deviceResource.getPathQuery()) != null) {
                throw new RegistrationException("URI namespace conflict with already registered resource: " + deviceResource);
            }
            ++n2;
        }
        object = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            Resource validatedResource = object[n2];
            this.registry.addResource(validatedResource);
            this.log.trace("Added remote device resource: " + validatedResource);
            ++n2;
        }
        Integer maxAgeSeconds = null;
        if (this.registry.getConfiguration() != null) {
            maxAgeSeconds = this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds();
        }
        if (maxAgeSeconds == null) {
            maxAgeSeconds = ((RemoteDeviceIdentity)device.getIdentity()).getMaxAgeSeconds();
        }
        RegistryItem<UDN, RemoteDevice> item = new RegistryItem<UDN, RemoteDevice>(((RemoteDeviceIdentity)device.getIdentity()).getUdn(), device, maxAgeSeconds);
        this.log.trace("Adding hydrated remote device to registry with " + item.getExpirationDetails().getMaxAgeSeconds() + " seconds expiration: " + device);
        this.getDeviceItems().add(item);
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("-------------------------- START Registry Namespace -----------------------------------\n");
            for (Resource resource : this.registry.getResources()) {
                sb.append(resource).append("\n");
            }
            sb.append("-------------------------- END Registry Namespace -----------------------------------");
            this.log.trace(sb.toString());
        }
        this.log.trace("Completely hydrated remote device graph available, calling listeners: " + device);
        for (final RegistryListener listener : this.registry.getListeners()) {
            this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.remoteDeviceAdded(RemoteItems.this.registry, device);
                }
            });
        }
    }

    boolean update(RemoteDeviceIdentity rdIdentity) {
        for (LocalDevice localDevice : this.registry.getLocalDevices()) {
            if (localDevice.findDevice(rdIdentity.getUdn()) == null) continue;
            this.log.trace("Ignoring update, a local device graph contains UDN");
            return true;
        }
        RemoteDevice registeredRemoteDevice = (RemoteDevice)this.get(rdIdentity.getUdn(), false);
        if (registeredRemoteDevice != null) {
            URL remoteDescriptorUrl;
            URL descriptorUrl;
            RemoteDeviceIdentity remoteDeviceIdentity = (RemoteDeviceIdentity)registeredRemoteDevice.getIdentity();
            if (remoteDeviceIdentity != null && (descriptorUrl = rdIdentity.getDescriptorURL()) != null & (remoteDescriptorUrl = remoteDeviceIdentity.getDescriptorURL()) != null && !descriptorUrl.getHost().equals(remoteDescriptorUrl.getHost())) {
                this.log.trace("IP adress has changed - removing the registered device");
                this.remove(registeredRemoteDevice);
                return false;
            }
            if (!registeredRemoteDevice.isRoot()) {
                this.log.trace("Updating root device of embedded: " + registeredRemoteDevice);
                registeredRemoteDevice = registeredRemoteDevice.getRoot();
            }
            final RegistryItem<UDN, RemoteDevice> item = new RegistryItem<UDN, RemoteDevice>(((RemoteDeviceIdentity)registeredRemoteDevice.getIdentity()).getUdn(), registeredRemoteDevice, this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds() != null ? this.registry.getConfiguration().getRemoteDeviceMaxAgeSeconds() : rdIdentity.getMaxAgeSeconds());
            this.log.trace("Updating expiration of: " + registeredRemoteDevice);
            this.getDeviceItems().remove(item);
            this.getDeviceItems().add(item);
            this.log.trace("Remote device updated, calling listeners: " + registeredRemoteDevice);
            for (final RegistryListener listener : this.registry.getListeners()) {
                this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.remoteDeviceUpdated(RemoteItems.this.registry, (RemoteDevice)item.getItem());
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    boolean remove(RemoteDevice remoteDevice) {
        return this.remove(remoteDevice, false);
    }

    boolean remove(RemoteDevice remoteDevice, boolean shuttingDown) throws RegistrationException {
        final RemoteDevice registeredDevice = (RemoteDevice)this.get(((RemoteDeviceIdentity)remoteDevice.getIdentity()).getUdn(), true);
        if (registeredDevice != null) {
            this.log.trace("Removing remote device from registry: " + remoteDevice);
            Resource[] resourceArray = this.getResources(registeredDevice);
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource deviceResource = resourceArray[n2];
                if (this.registry.removeResource(deviceResource)) {
                    this.log.trace("Unregistered resource: " + deviceResource);
                }
                ++n2;
            }
            Iterator it = this.getSubscriptionItems().iterator();
            while (it.hasNext()) {
                final RegistryItem outgoingSubscription = it.next();
                UDN subscriptionForUDN = ((RemoteDeviceIdentity)((RemoteDevice)((RemoteService)((RemoteGENASubscription)outgoingSubscription.getItem()).getService()).getDevice()).getIdentity()).getUdn();
                if (!subscriptionForUDN.equals(((RemoteDeviceIdentity)registeredDevice.getIdentity()).getUdn())) continue;
                this.log.trace("Removing outgoing subscription: " + outgoingSubscription.getKey());
                it.remove();
                if (shuttingDown) continue;
                this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ((RemoteGENASubscription)outgoingSubscription.getItem()).end(CancelReason.DEVICE_WAS_REMOVED, null);
                    }
                });
            }
            if (!shuttingDown) {
                for (final RegistryListener listener : this.registry.getListeners()) {
                    this.registry.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.remoteDeviceRemoved(RemoteItems.this.registry, registeredDevice);
                        }
                    });
                }
            }
            this.getDeviceItems().remove(new RegistryItem(((RemoteDeviceIdentity)registeredDevice.getIdentity()).getUdn()));
            return true;
        }
        return false;
    }

    @Override
    void removeAll() {
        this.removeAll(false);
    }

    void removeAll(boolean shuttingDown) {
        RemoteDevice[] allDevices;
        RemoteDevice[] remoteDeviceArray = allDevices = this.get().toArray(new RemoteDevice[this.get().size()]);
        int n = allDevices.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteDevice device = remoteDeviceArray[n2];
            this.remove(device, shuttingDown);
            ++n2;
        }
    }

    void start() {
    }

    @Override
    void maintain() {
        if (this.getDeviceItems().isEmpty()) {
            return;
        }
        HashMap<UDN, RemoteDevice> expiredRemoteDevices = new HashMap<UDN, RemoteDevice>();
        for (RegistryItem remoteItem : this.getDeviceItems()) {
            this.log.trace("Device '{}' expires in seconds: {}", remoteItem.getItem(), (Object)remoteItem.getExpirationDetails().getSecondsUntilExpiration());
            if (!remoteItem.getExpirationDetails().hasExpired(false)) continue;
            expiredRemoteDevices.put(remoteItem.getKey(), (RemoteDevice)remoteItem.getItem());
        }
        for (RemoteDevice remoteDevice : expiredRemoteDevices.values()) {
            this.log.trace("Removing expired: " + remoteDevice);
            this.remove(remoteDevice);
        }
        HashSet<RemoteGENASubscription> expiredOutgoingSubscriptions = new HashSet<RemoteGENASubscription>();
        for (RegistryItem item : this.getSubscriptionItems()) {
            ExpirationDetails expirationDetails = item.getExpirationDetails();
            if (expirationDetails.getRenewAttempts() >= 1 || !expirationDetails.hasExpired(true)) continue;
            expiredOutgoingSubscriptions.add((RemoteGENASubscription)item.getItem());
            expirationDetails.renewAttempted();
        }
        for (RemoteGENASubscription subscription : expiredOutgoingSubscriptions) {
            this.log.trace("Renewing outgoing subscription: " + subscription);
            this.renewOutgoingSubscription(subscription);
        }
    }

    public void resume() {
        this.log.trace("Updating remote device expiration timestamps on resume");
        ArrayList<RemoteDeviceIdentity> toUpdate = new ArrayList<RemoteDeviceIdentity>();
        for (RegistryItem remoteItem : this.getDeviceItems()) {
            toUpdate.add((RemoteDeviceIdentity)((RemoteDevice)remoteItem.getItem()).getIdentity());
        }
        for (RemoteDeviceIdentity identity : toUpdate) {
            this.update(identity);
        }
    }

    @Override
    void shutdown() {
        this.log.trace("Cancelling all outgoing subscriptions to remote devices during shutdown");
        ArrayList<RemoteGENASubscription> remoteSubscriptions = new ArrayList<RemoteGENASubscription>();
        for (RegistryItem item : this.getSubscriptionItems()) {
            remoteSubscriptions.add((RemoteGENASubscription)item.getItem());
        }
        for (RemoteGENASubscription remoteSubscription : remoteSubscriptions) {
            this.registry.getProtocolFactory().createSendingUnsubscribe(remoteSubscription).run();
        }
        this.log.trace("Removing all remote devices from registry during shutdown");
        this.removeAll(true);
    }

    protected void renewOutgoingSubscription(RemoteGENASubscription subscription) {
        this.registry.executeAsyncProtocol(this.registry.getProtocolFactory().createSendingRenewal(subscription));
    }
}

