/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.net.URL;
import org.jupnp.UpnpService;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.gena.OutgoingEventRequestMessage;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingEvent
extends SendingSync<OutgoingEventRequestMessage, StreamResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(SendingEvent.class);
    protected final String subscriptionId;
    protected final OutgoingEventRequestMessage[] requestMessages;
    protected final UnsignedIntegerFourBytes currentSequence;

    public SendingEvent(UpnpService upnpService, LocalGENASubscription subscription) {
        super(upnpService, null);
        this.subscriptionId = subscription.getSubscriptionId();
        this.requestMessages = new OutgoingEventRequestMessage[subscription.getCallbackURLs().size()];
        int i = 0;
        for (URL url : subscription.getCallbackURLs()) {
            this.requestMessages[i] = new OutgoingEventRequestMessage(subscription, url);
            this.getUpnpService().getConfiguration().getGenaEventProcessor().writeBody(this.requestMessages[i]);
            ++i;
        }
        this.currentSequence = subscription.getCurrentSequence();
        subscription.incrementSequence();
    }

    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        this.log.trace("Sending event for subscription: " + this.subscriptionId);
        StreamResponseMessage lastResponse = null;
        OutgoingEventRequestMessage[] outgoingEventRequestMessageArray = this.requestMessages;
        int n = this.requestMessages.length;
        int n2 = 0;
        while (n2 < n) {
            OutgoingEventRequestMessage requestMessage = outgoingEventRequestMessageArray[n2];
            if (this.currentSequence.getValue() == 0L) {
                this.log.trace("Sending initial event message to callback URL: " + requestMessage.getUri());
            } else {
                this.log.trace("Sending event message '" + this.currentSequence + "' to callback URL: " + requestMessage.getUri());
            }
            lastResponse = this.getUpnpService().getRouter().send(requestMessage);
            this.log.trace("Received event callback response: " + lastResponse);
            ++n2;
        }
        return lastResponse;
    }
}

