/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.net.URL;
import org.jupnp.UpnpService;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.action.ActionCancelledException;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.control.IncomingActionResponseMessage;
import org.jupnp.model.message.control.OutgoingActionRequestMessage;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingAction
extends SendingSync<OutgoingActionRequestMessage, IncomingActionResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(SendingAction.class);
    protected final ActionInvocation actionInvocation;

    public SendingAction(UpnpService upnpService, ActionInvocation actionInvocation, URL controlURL) {
        super(upnpService, new OutgoingActionRequestMessage(actionInvocation, controlURL));
        this.actionInvocation = actionInvocation;
    }

    @Override
    protected IncomingActionResponseMessage executeSync() throws RouterException {
        return this.invokeRemote((OutgoingActionRequestMessage)this.getInputMessage());
    }

    protected IncomingActionResponseMessage invokeRemote(OutgoingActionRequestMessage requestMessage) throws RouterException {
        StreamResponseMessage streamResponse;
        IncomingActionResponseMessage responseMessage;
        block7: {
            Object device = ((Service)this.actionInvocation.getAction().getService()).getDevice();
            this.log.trace("Sending outgoing action call '" + this.actionInvocation.getAction().getName() + "' to remote service of: " + device);
            responseMessage = null;
            try {
                streamResponse = this.sendRemoteRequest(requestMessage);
                if (streamResponse != null) break block7;
                this.log.trace("No connection or no no response received, returning null");
                this.actionInvocation.setFailure(new ActionException(ErrorCode.ACTION_FAILED, "Connection error or no response received"));
                return null;
            }
            catch (ActionException ex) {
                this.log.trace("Remote action invocation failed, returning Internal Server Error message: " + ex.getMessage());
                this.actionInvocation.setFailure(ex);
                if (responseMessage == null || !((UpnpResponse)responseMessage.getOperation()).isFailed()) {
                    return new IncomingActionResponseMessage(new UpnpResponse(UpnpResponse.Status.INTERNAL_SERVER_ERROR));
                }
                return responseMessage;
            }
        }
        responseMessage = new IncomingActionResponseMessage(streamResponse);
        if (responseMessage.isFailedNonRecoverable()) {
            this.log.trace("Response was a non-recoverable failure: " + responseMessage);
            throw new ActionException(ErrorCode.ACTION_FAILED, "Non-recoverable remote execution failure: " + ((UpnpResponse)responseMessage.getOperation()).getResponseDetails());
        }
        if (responseMessage.isFailedRecoverable()) {
            this.handleResponseFailure(responseMessage);
        } else {
            this.handleResponse(responseMessage);
        }
        return responseMessage;
    }

    protected StreamResponseMessage sendRemoteRequest(OutgoingActionRequestMessage requestMessage) throws ActionException, RouterException {
        try {
            this.log.trace("Writing SOAP request body of: " + requestMessage);
            this.getUpnpService().getConfiguration().getSoapActionProcessor().writeBody(requestMessage, this.actionInvocation);
            this.log.trace("Sending SOAP body of message as stream to remote device");
            return this.getUpnpService().getRouter().send(requestMessage);
        }
        catch (RouterException ex) {
            Throwable cause = Exceptions.unwrap(ex);
            if (cause instanceof InterruptedException) {
                this.log.trace("Sending action request message was interrupted: " + cause);
                throw new ActionCancelledException((InterruptedException)cause);
            }
            throw ex;
        }
        catch (UnsupportedDataException ex) {
            this.log.trace("Error writing SOAP body: " + ex);
            this.log.trace("Exception root cause: ", Exceptions.unwrap(ex));
            throw new ActionException(ErrorCode.ACTION_FAILED, "Error writing request message. " + ex.getMessage());
        }
    }

    protected void handleResponse(IncomingActionResponseMessage responseMsg) throws ActionException {
        try {
            this.log.trace("Received response for outgoing call, reading SOAP response body: " + responseMsg);
            this.getUpnpService().getConfiguration().getSoapActionProcessor().readBody(responseMsg, this.actionInvocation);
        }
        catch (UnsupportedDataException ex) {
            this.log.trace("Error reading SOAP body: " + ex);
            this.log.trace("Exception root cause: ", Exceptions.unwrap(ex));
            throw new ActionException(ErrorCode.ACTION_FAILED, "Error reading SOAP response message. " + ex.getMessage(), false);
        }
    }

    protected void handleResponseFailure(IncomingActionResponseMessage responseMsg) throws ActionException {
        try {
            this.log.trace("Received response with Internal Server Error, reading SOAP failure message");
            this.getUpnpService().getConfiguration().getSoapActionProcessor().readBody(responseMsg, this.actionInvocation);
        }
        catch (UnsupportedDataException ex) {
            this.log.trace("Error reading SOAP body: " + ex);
            this.log.trace("Exception root cause: ", Exceptions.unwrap(ex));
            throw new ActionException(ErrorCode.ACTION_FAILED, "Error reading SOAP response failure message. " + ex.getMessage(), false);
        }
    }
}

