/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jupnp.UpnpService;
import org.jupnp.binding.xml.DescriptorBindingException;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.ValidationException;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Icon;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.RegistrationException;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveRemoteDescriptors
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(RetrieveRemoteDescriptors.class);
    private final UpnpService upnpService;
    private RemoteDevice rd;
    private static final ConcurrentHashMap<URL, Boolean> activeRetrievals = new ConcurrentHashMap();
    protected List<UDN> errorsAlreadyLogged = new ArrayList<UDN>();

    public RetrieveRemoteDescriptors(UpnpService upnpService, RemoteDevice rd) {
        this.upnpService = upnpService;
        this.rd = rd;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public void run() {
        URL deviceURL = ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL();
        if (this.getUpnpService().getRegistry().getRemoteDevice(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn(), true) != null) {
            this.log.trace("Exiting early, already discovered: " + deviceURL);
            return;
        }
        if (activeRetrievals.putIfAbsent(deviceURL, Boolean.TRUE) != null) {
            this.log.trace("Exiting early, active retrieval for URL already in progress: {}", (Object)deviceURL);
            return;
        }
        try {
            try {
                this.describe();
            }
            catch (RouterException ex) {
                this.log.warn("Descriptor retrieval failed: " + deviceURL, (Throwable)ex);
                activeRetrievals.remove(deviceURL);
            }
        }
        finally {
            activeRetrievals.remove(deviceURL);
        }
    }

    protected void describe() throws RouterException {
        String descriptorContent;
        StreamResponseMessage deviceDescMsg;
        if (this.getUpnpService().getRouter() == null) {
            this.log.warn("Router not yet initialized");
            return;
        }
        try {
            StreamRequestMessage deviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            UpnpHeaders headers = this.getUpnpService().getConfiguration().getDescriptorRetrievalHeaders((RemoteDeviceIdentity)this.rd.getIdentity());
            if (headers != null) {
                deviceDescRetrievalMsg.getHeaders().putAll(headers);
            }
            this.log.debug("Sending device descriptor retrieval message: " + deviceDescRetrievalMsg);
            deviceDescMsg = this.getUpnpService().getRouter().send(deviceDescRetrievalMsg);
        }
        catch (IllegalArgumentException ex) {
            this.log.warn("Device descriptor retrieval failed: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL() + ", possibly invalid URL: " + ex);
            return;
        }
        if (deviceDescMsg == null) {
            this.log.warn("Device descriptor retrieval failed, no response: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        if (((UpnpResponse)deviceDescMsg.getOperation()).isFailed()) {
            this.log.warn("Device descriptor retrieval failed: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL() + ", " + ((UpnpResponse)deviceDescMsg.getOperation()).getResponseDetails());
            return;
        }
        if (!deviceDescMsg.isContentTypeTextUDA()) {
            this.log.debug("Received device descriptor without or with invalid Content-Type: " + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
        }
        if ((descriptorContent = deviceDescMsg.getBodyString()) == null || descriptorContent.length() == 0) {
            this.log.warn("Received empty device descriptor:" + ((RemoteDeviceIdentity)this.rd.getIdentity()).getDescriptorURL());
            return;
        }
        this.log.debug("Received root device descriptor: " + deviceDescMsg);
        this.describe(descriptorContent);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void describe(String descriptorXML) throws RouterException {
        notifiedStart = false;
        describedDevice = null;
        try {
            deviceDescriptorBinder = this.getUpnpService().getConfiguration().getDeviceDescriptorBinderUDA10();
            describedDevice = deviceDescriptorBinder.describe(this.rd, descriptorXML);
            this.log.debug("Remote device described (without services) notifying listeners: " + describedDevice);
            notifiedStart = this.getUpnpService().getRegistry().notifyDiscoveryStart(describedDevice);
            this.log.debug("Hydrating described device's services: " + describedDevice);
            hydratedDevice = this.describeServices(describedDevice);
            if (hydratedDevice == null) {
                if (!this.errorsAlreadyLogged.contains(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn())) {
                    this.errorsAlreadyLogged.add(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn());
                    this.log.warn("Device service description failed: " + this.rd);
                }
                if (!notifiedStart) return;
                this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, new DescriptorBindingException("Device service description failed: " + this.rd));
                this.log.debug("Adding described remote device to registry: " + describedDevice);
                this.getUpnpService().getRegistry().addDevice(describedDevice);
                return;
            }
            this.log.debug("Adding fully hydrated remote device to registry: " + hydratedDevice);
            this.getUpnpService().getRegistry().addDevice(hydratedDevice);
            return;
        }
        catch (ValidationException ex) {
            if (this.errorsAlreadyLogged.contains(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn())) return;
            this.errorsAlreadyLogged.add(((RemoteDeviceIdentity)this.rd.getIdentity()).getUdn());
            this.log.warn("Could not validate device model: " + this.rd);
            ** for (validationError : ex.getErrors())
        }
lbl-1000:
        // 1 sources

        {
            this.log.warn(validationError.toString());
            continue;
        }
lbl31:
        // 1 sources

        if (describedDevice == null || !notifiedStart) return;
        this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
        return;
        catch (DescriptorBindingException ex) {
            this.log.warn("Could not hydrate device or its services from descriptor: " + this.rd);
            this.log.warn("Cause was: " + Exceptions.unwrap(ex));
            if (describedDevice == null || !notifiedStart) return;
            this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
            return;
        }
        catch (RegistrationException ex) {
            this.log.warn("Adding hydrated device to registry failed: " + this.rd);
            this.log.warn("Cause was: " + ex.toString());
            if (describedDevice == null || !notifiedStart) return;
            this.getUpnpService().getRegistry().notifyDiscoveryFailure(describedDevice, ex);
        }
    }

    protected RemoteDevice describeServices(RemoteDevice currentDevice) throws RouterException, DescriptorBindingException, ValidationException {
        ArrayList<RemoteService> describedServices = new ArrayList<RemoteService>();
        if (currentDevice.hasServices()) {
            List<RemoteService> filteredServices = this.filterExclusiveServices(currentDevice.getServices());
            for (RemoteService service : filteredServices) {
                RemoteService svc = this.describeService(service);
                if (svc == null) continue;
                describedServices.add(svc);
            }
        }
        ArrayList<RemoteDevice> describedEmbeddedDevices = new ArrayList<RemoteDevice>();
        if (currentDevice.hasEmbeddedDevices()) {
            RemoteDevice[] remoteDeviceArray = currentDevice.getEmbeddedDevices();
            int svc = remoteDeviceArray.length;
            int n = 0;
            while (n < svc) {
                RemoteDevice describedEmbeddedDevice;
                RemoteDevice embeddedDevice = remoteDeviceArray[n];
                if (embeddedDevice != null && (describedEmbeddedDevice = this.describeServices(embeddedDevice)) != null) {
                    describedEmbeddedDevices.add(describedEmbeddedDevice);
                }
                ++n;
            }
        }
        if (currentDevice.hasServices() && describedServices.size() == 0 || currentDevice.hasEmbeddedDevices() && describedEmbeddedDevices.size() == 0) {
            return null;
        }
        Icon[] iconDupes = new Icon[currentDevice.getIcons().length];
        int i = 0;
        while (i < currentDevice.getIcons().length) {
            Icon icon = currentDevice.getIcons()[i];
            iconDupes[i] = icon.deepCopy();
            ++i;
        }
        return currentDevice.newInstance(((RemoteDeviceIdentity)currentDevice.getIdentity()).getUdn(), currentDevice.getVersion(), currentDevice.getType(), currentDevice.getDetails(), iconDupes, currentDevice.toServiceArray((Collection<RemoteService>)describedServices), (List<RemoteDevice>)describedEmbeddedDevices);
    }

    protected RemoteService describeService(RemoteService service) throws RouterException, DescriptorBindingException, ValidationException {
        String descriptorContent;
        URL descriptorURL;
        try {
            descriptorURL = ((RemoteDevice)service.getDevice()).normalizeURI(service.getDescriptorURI());
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Could not normalize service descriptor URL: " + service.getDescriptorURI());
            return null;
        }
        StreamRequestMessage serviceDescRetrievalMsg = new StreamRequestMessage(UpnpRequest.Method.GET, descriptorURL);
        UpnpHeaders headers = this.getUpnpService().getConfiguration().getDescriptorRetrievalHeaders((RemoteDeviceIdentity)((RemoteDevice)service.getDevice()).getIdentity());
        if (headers != null) {
            serviceDescRetrievalMsg.getHeaders().putAll(headers);
        }
        this.log.debug("Sending service descriptor retrieval message: " + serviceDescRetrievalMsg);
        StreamResponseMessage serviceDescMsg = this.getUpnpService().getRouter().send(serviceDescRetrievalMsg);
        if (serviceDescMsg == null) {
            this.log.warn("Could not retrieve service descriptor, no response: " + service);
            return null;
        }
        if (((UpnpResponse)serviceDescMsg.getOperation()).isFailed()) {
            this.log.warn("Service descriptor retrieval failed: " + descriptorURL + ", " + ((UpnpResponse)serviceDescMsg.getOperation()).getResponseDetails());
            return null;
        }
        if (!serviceDescMsg.isContentTypeTextUDA()) {
            this.log.debug("Received service descriptor without or with invalid Content-Type: " + descriptorURL);
        }
        if ((descriptorContent = serviceDescMsg.getBodyString()) == null || descriptorContent.length() == 0) {
            this.log.warn("Received empty service descriptor:" + descriptorURL);
            return null;
        }
        this.log.debug("Received service descriptor, hydrating service model: " + serviceDescMsg);
        ServiceDescriptorBinder serviceDescriptorBinder = this.getUpnpService().getConfiguration().getServiceDescriptorBinderUDA10();
        return serviceDescriptorBinder.describe(service, descriptorContent);
    }

    protected List<RemoteService> filterExclusiveServices(RemoteService[] services) {
        ServiceType[] exclusiveTypes = this.getUpnpService().getConfiguration().getExclusiveServiceTypes();
        if (exclusiveTypes == null || exclusiveTypes.length == 0) {
            return Arrays.asList(services);
        }
        ArrayList<RemoteService> exclusiveServices = new ArrayList<RemoteService>();
        RemoteService[] remoteServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteService discoveredService = remoteServiceArray[n2];
            ServiceType[] serviceTypeArray = exclusiveTypes;
            int n3 = exclusiveTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                ServiceType exclusiveType = serviceTypeArray[n4];
                if (discoveredService.getServiceType().implementsVersion(exclusiveType)) {
                    this.log.debug("Including exclusive service: " + discoveredService);
                    exclusiveServices.add(discoveredService);
                } else {
                    this.log.debug("Excluding unwanted service: " + exclusiveType);
                }
                ++n4;
            }
            ++n2;
        }
        return exclusiveServices;
    }

    public static boolean isRetrievalInProgress(RemoteDevice rd) {
        if (rd == null) {
            throw new IllegalArgumentException("RemoteDevice must not be null!");
        }
        return activeRetrievals.containsKey(((RemoteDeviceIdentity)rd.getIdentity()).getDescriptorURL());
    }
}

