/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.AbstractDatatype;
import org.jupnp.model.types.InvalidValueException;

public class IntegerDatatype
extends AbstractDatatype<Integer> {
    private int byteSize;

    public IntegerDatatype(int byteSize) {
        this.byteSize = byteSize;
    }

    @Override
    public boolean isHandlingJavaType(Class type) {
        return type == Integer.TYPE || Integer.class.isAssignableFrom(type);
    }

    @Override
    public Integer valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        try {
            Integer value = Integer.parseInt(s.trim());
            if (!this.isValid(value)) {
                throw new InvalidValueException("Not a " + this.getByteSize() + " byte(s) integer: " + s);
            }
            return value;
        }
        catch (NumberFormatException ex) {
            if (s.equals("NOT_IMPLEMENTED")) {
                return this.getMaxValue();
            }
            throw new InvalidValueException("Can't convert string to number: " + s, ex);
        }
    }

    @Override
    public boolean isValid(Integer value) {
        return value == null || value >= this.getMinValue() && value <= this.getMaxValue();
    }

    public int getMinValue() {
        switch (this.getByteSize()) {
            case 1: {
                return -128;
            }
            case 2: {
                return Short.MIN_VALUE;
            }
            case 4: {
                return Integer.MIN_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid integer byte size: " + this.getByteSize());
    }

    public int getMaxValue() {
        switch (this.getByteSize()) {
            case 1: {
                return 127;
            }
            case 2: {
                return Short.MAX_VALUE;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("Invalid integer byte size: " + this.getByteSize());
    }

    public int getByteSize() {
        return this.byteSize;
    }
}

