/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import org.jupnp.model.types.AbstractDatatype;
import org.jupnp.model.types.InvalidValueException;

public class DoubleDatatype
extends AbstractDatatype<Double> {
    @Override
    public boolean isHandlingJavaType(Class type) {
        return type == Double.TYPE || Double.class.isAssignableFrom(type);
    }

    @Override
    public Double valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException("Can't convert string to number: " + s, ex);
        }
    }
}

