/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.action;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.jupnp.model.action.AbstractActionExecutor;
import org.jupnp.model.action.ActionArgumentValue;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.action.RemoteActionInvocation;
import org.jupnp.model.meta.ActionArgument;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.state.StateVariableAccessor;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.util.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodActionExecutor
extends AbstractActionExecutor {
    private Logger log = LoggerFactory.getLogger(MethodActionExecutor.class);
    protected Method method;

    public MethodActionExecutor(Method method) {
        this.method = method;
    }

    public MethodActionExecutor(Map<ActionArgument<LocalService>, StateVariableAccessor> outputArgumentAccessors, Method method) {
        super(outputArgumentAccessors);
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    protected void execute(ActionInvocation<LocalService> actionInvocation, Object serviceImpl) throws Exception {
        Object result;
        Object[] inputArgumentValues = this.createInputArgumentValues(actionInvocation, this.method);
        if (!actionInvocation.getAction().hasOutputArguments()) {
            this.log.trace("Calling local service method with no output arguments: " + this.method);
            Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            return;
        }
        boolean isVoid = this.method.getReturnType().equals(Void.TYPE);
        this.log.trace("Calling local service method with output arguments: " + this.method);
        boolean isArrayResultProcessed = true;
        if (isVoid) {
            this.log.trace("Action method is void, calling declared accessors(s) on service instance to retrieve ouput argument(s)");
            Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            result = this.readOutputArgumentValues(actionInvocation.getAction(), serviceImpl);
        } else if (this.isUseOutputArgumentAccessors(actionInvocation)) {
            this.log.trace("Action method is not void, calling declared accessor(s) on returned instance to retrieve ouput argument(s)");
            Object returnedInstance = Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            result = this.readOutputArgumentValues(actionInvocation.getAction(), returnedInstance);
        } else {
            this.log.trace("Action method is not void, using returned value as (single) output argument");
            result = Reflections.invoke(this.method, serviceImpl, inputArgumentValues);
            isArrayResultProcessed = false;
        }
        ActionArgument<LocalService>[] outputArgs = actionInvocation.getAction().getOutputArguments();
        if (isArrayResultProcessed && result instanceof Object[]) {
            Object[] results = (Object[])result;
            this.log.trace("Accessors returned Object[], setting output argument values: " + results.length);
            int i = 0;
            while (i < outputArgs.length) {
                this.setOutputArgumentValue(actionInvocation, outputArgs[i], results[i]);
                ++i;
            }
        } else if (outputArgs.length == 1) {
            this.setOutputArgumentValue(actionInvocation, outputArgs[0], result);
        } else {
            throw new ActionException(ErrorCode.ACTION_FAILED, "Method return does not match required number of output arguments: " + outputArgs.length);
        }
    }

    protected boolean isUseOutputArgumentAccessors(ActionInvocation<LocalService> actionInvocation) {
        ActionArgument<LocalService>[] actionArgumentArray = actionInvocation.getAction().getOutputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument<LocalService> argument = actionArgumentArray[n2];
            if (this.getOutputArgumentAccessors().get(argument) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Object[] createInputArgumentValues(ActionInvocation<LocalService> actionInvocation, Method method) throws ActionException {
        LocalService service = actionInvocation.getAction().getService();
        ArrayList<Object> values = new ArrayList<Object>();
        int i = 0;
        ActionArgument<LocalService>[] actionArgumentArray = actionInvocation.getAction().getInputArguments();
        int n = actionArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionArgument<LocalService> argument = actionArgumentArray[n2];
            Class<?> methodParameterType = method.getParameterTypes()[i];
            ActionArgumentValue<LocalService> inputValue = actionInvocation.getInput(argument);
            if (methodParameterType.isPrimitive() && (inputValue == null || inputValue.toString().length() == 0)) {
                throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Primitive action method argument '" + argument.getName() + "' requires input value, can't be null or empty string");
            }
            if (inputValue == null) {
                values.add(i++, null);
            } else {
                String inputCallValueString = inputValue.toString();
                if (inputCallValueString.length() > 0 && service.isStringConvertibleType(methodParameterType) && !methodParameterType.isEnum()) {
                    try {
                        Constructor<?> ctor = methodParameterType.getConstructor(String.class);
                        this.log.trace("Creating new input argument value instance with String.class constructor of type: " + methodParameterType);
                        Object o = ctor.newInstance(inputCallValueString);
                        values.add(i++, o);
                    }
                    catch (Exception ex) {
                        this.log.warn("Error preparing action method call: " + method);
                        this.log.warn("Can't convert input argument string to desired type of '" + argument.getName() + "': " + ex);
                        throw new ActionException(ErrorCode.ARGUMENT_VALUE_INVALID, "Can't convert input argument string to desired type of '" + argument.getName() + "': " + ex);
                    }
                } else {
                    values.add(i++, inputValue.getValue());
                }
            }
            ++n2;
        }
        if (method.getParameterTypes().length > 0 && RemoteClientInfo.class.isAssignableFrom(method.getParameterTypes()[method.getParameterTypes().length - 1])) {
            if (actionInvocation instanceof RemoteActionInvocation && ((RemoteActionInvocation)actionInvocation).getRemoteClientInfo() != null) {
                this.log.trace("Providing remote client info as last action method input argument: " + method);
                values.add(i, ((RemoteActionInvocation)actionInvocation).getRemoteClientInfo());
            } else {
                values.add(i, null);
            }
        }
        return values.toArray(new Object[values.size()]);
    }
}

