/*
 * Decompiled with CFR 0.152.
 */
package ru.yole.jkid.deserialization;

import java.io.Reader;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yole.jkid.deserialization.MalformedJSONException;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0019J\r\u0010\u001a\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fR$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lru/yole/jkid/deserialization/CharReader;", "", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "<set-?>", "", "eof", "getEof", "()Z", "setEof", "(Z)V", "nextChar", "", "Ljava/lang/Character;", "getReader", "()Ljava/io/Reader;", "tokenBuffer", "", "advance", "", "expectText", "text", "", "followedBy", "", "peekNext", "()Ljava/lang/Character;", "readNext", "readNextChars", "length", "", "build"})
public final class CharReader {
    private final char[] tokenBuffer;
    private Character nextChar;
    private boolean eof;
    @NotNull
    private final Reader reader;

    public final boolean getEof() {
        return this.eof;
    }

    private final void setEof(boolean bl) {
        this.eof = bl;
    }

    private final void advance() {
        if (this.eof) {
            return;
        }
        int c = this.reader.read();
        if (c == -1) {
            this.eof = true;
        } else {
            this.nextChar = Character.valueOf((char)c);
        }
    }

    @Nullable
    public final Character peekNext() {
        if (this.nextChar == null) {
            this.advance();
        }
        return this.eof ? null : this.nextChar;
    }

    @Nullable
    public final Character readNext() {
        Character c;
        Character $receiver = c = this.peekNext();
        this.nextChar = null;
        return c;
    }

    @NotNull
    public final String readNextChars(int length) {
        boolean bl;
        boolean bl2 = bl = this.nextChar == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = length <= this.tokenBuffer.length;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.reader.read(this.tokenBuffer, 0, length) != length) {
            throw (Throwable)new MalformedJSONException("Premature end of data");
        }
        char[] cArray = this.tokenBuffer;
        int n = 0;
        return new String(cArray, n, length);
    }

    public final void expectText(@NotNull String text, @NotNull Set<Character> followedBy) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(followedBy, (String)"followedBy");
        if (Intrinsics.areEqual((Object)this.readNextChars(text.length()), (Object)text) ^ true) {
            throw (Throwable)new MalformedJSONException("Expected text " + text);
        }
        Character next = this.peekNext();
        if (next != null && !followedBy.contains(next)) {
            throw (Throwable)new MalformedJSONException("Expected text in " + followedBy);
        }
    }

    @NotNull
    public final Reader getReader() {
        return this.reader;
    }

    public CharReader(@NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.reader = reader;
        this.tokenBuffer = new char[4];
    }
}

