/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import com.google.common.base.Preconditions;
import io.vertx.core.buffer.Buffer;
import org.apache.tuweni.bytes.AbstractBytes;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;

class BufferWrappingBytes
extends AbstractBytes {
    protected final Buffer buffer;

    BufferWrappingBytes(Buffer buffer) {
        this.buffer = buffer;
    }

    BufferWrappingBytes(Buffer buffer, int offset, int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Invalid negative length");
        int bufferLength = buffer.length();
        Preconditions.checkElementIndex((int)offset, (int)(bufferLength + 1));
        Preconditions.checkArgument((offset + length <= bufferLength ? 1 : 0) != 0, (String)"Provided length %s is too big: the buffer has size %s and has only %s bytes from %s", (Object)length, (Object)bufferLength, (Object)(bufferLength - offset), (Object)offset);
        this.buffer = offset == 0 && length == bufferLength ? buffer : buffer.slice(offset, offset + length);
    }

    @Override
    public int size() {
        return this.buffer.length();
    }

    @Override
    public byte get(int i) {
        return this.buffer.getByte(i);
    }

    @Override
    public int getInt(int i) {
        return this.buffer.getInt(i);
    }

    @Override
    public long getLong(int i) {
        return this.buffer.getLong(i);
    }

    @Override
    public Bytes slice(int i, int length) {
        int size = this.buffer.length();
        if (i == 0 && length == size) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Preconditions.checkElementIndex((int)i, (int)size);
        Preconditions.checkArgument((i + length <= size ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has size %s and has only %s bytes from %s", (Object)length, (Object)size, (Object)(size - i), (Object)i);
        return new BufferWrappingBytes(this.buffer.slice(i, i + length));
    }

    @Override
    public Bytes copy() {
        return Bytes.wrap(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return MutableBytes.wrap(this.toArray());
    }

    @Override
    public void appendTo(Buffer buffer) {
        buffer.appendBuffer(this.buffer);
    }

    @Override
    public byte[] toArray() {
        return this.buffer.getBytes();
    }
}

