/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.bytes;

import com.google.common.base.Preconditions;
import org.apache.tuweni.bytes.ArrayWrappingBytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableArrayWrappingBytes32;
import org.apache.tuweni.bytes.MutableBytes32;

final class ArrayWrappingBytes32
extends ArrayWrappingBytes
implements Bytes32 {
    ArrayWrappingBytes32(byte[] bytes) {
        this(ArrayWrappingBytes32.checkLength(bytes), 0);
    }

    ArrayWrappingBytes32(byte[] bytes, int offset) {
        super(ArrayWrappingBytes32.checkLength(bytes, offset), offset, 32);
    }

    private static byte[] checkLength(byte[] bytes) {
        Preconditions.checkArgument((bytes.length == 32 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)32, (int)bytes.length);
        return bytes;
    }

    private static byte[] checkLength(byte[] bytes, int offset) {
        Preconditions.checkArgument((bytes.length - offset >= 32 ? 1 : 0) != 0, (String)"Expected at least %s bytes from offset %s but got only %s", (Object)32, (Object)offset, (Object)(bytes.length - offset));
        return bytes;
    }

    @Override
    public Bytes32 copy() {
        if (this.offset == 0 && this.length == this.bytes.length) {
            return this;
        }
        return new ArrayWrappingBytes32(this.toArray());
    }

    @Override
    public MutableBytes32 mutableCopy() {
        return new MutableArrayWrappingBytes32(this.toArray());
    }
}

