/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.document.impl.DocumentImplUtils;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

class ResourceCollectionContainer
implements IReportable {
    private final ResourceCollection rc;

    ResourceCollectionContainer(ResourceCollection rc) {
        this.rc = rc;
    }

    public void run(RatReport report) throws RatException {
        ResourceDocument document = new ResourceDocument();
        for (Resource r : this.rc) {
            if (r.isDirectory()) continue;
            document.setResource(r);
            document.getMetaData().clear();
            report.report((Document)document);
        }
    }

    private class ResourceDocument
    implements Document {
        private Resource resource;
        private final MetaData metaData = new MetaData();

        private ResourceDocument() {
        }

        private void setResource(Resource resource) {
            this.resource = resource;
        }

        public Reader reader() throws IOException {
            InputStream in = this.resource.getInputStream();
            InputStreamReader result = new InputStreamReader(in);
            return result;
        }

        public String getName() {
            String result = null;
            if (this.resource instanceof FileResource) {
                FileResource fileResource = (FileResource)this.resource;
                File file = fileResource.getFile();
                result = DocumentImplUtils.toName((File)file);
            } else {
                result = this.resource.getName();
            }
            return result;
        }

        public boolean isComposite() {
            if (this.resource instanceof FileResource) {
                FileResource fileResource = (FileResource)this.resource;
                File file = fileResource.getFile();
                return DocumentImplUtils.isZip((File)file);
            }
            return false;
        }

        public MetaData getMetaData() {
            return this.metaData;
        }

        public InputStream inputStream() throws IOException {
            return this.resource.getInputStream();
        }
    }
}

