/*
 * Decompiled with CFR 0.152.
 */
package com.bun.miitmdid.core;

import android.content.Context;
import android.support.annotation.Keep;
import android.util.Log;
import com.bun.miitmdid.core.IIdentifierListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Keep
public class MdidSdkHelper {
    public static String TAG = MdidSdkHelper.class.getSimpleName();

    @Keep
    public static int InitSdk(Context context, boolean bl, IIdentifierListener iIdentifierListener) {
        try {
            String string = "com.bun.miitmdid.core.MdidSdk";
            String string2 = "InitSdk";
            Class<?> clazz = Class.forName(string);
            if (clazz == null) {
                MdidSdkHelper.logd(bl, "not found class:" + string);
                return 1008615;
            }
            Constructor<?> constructor = clazz.getConstructor(Boolean.TYPE);
            if (constructor == null) {
                MdidSdkHelper.logd(bl, "not found MdidSdk Constructor");
                return 1008615;
            }
            Object obj = constructor.newInstance(bl);
            if (obj == null) {
                MdidSdkHelper.logd(bl, "Create MdidSdk Instance failed");
                return 1008615;
            }
            Method method = clazz.getDeclaredMethod(string2, Context.class, IIdentifierListener.class);
            if (method == null) {
                MdidSdkHelper.logd(bl, "not found MdidSdk " + string2 + " function");
                return 1008615;
            }
            Object object = method.invoke(obj, context, iIdentifierListener);
            int n = (Integer)object;
            MdidSdkHelper.logd(bl, "call and retvalue:" + n);
            return n;
        }
        catch (ClassNotFoundException classNotFoundException) {
            MdidSdkHelper.loge(bl, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MdidSdkHelper.loge(bl, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            MdidSdkHelper.loge(bl, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            MdidSdkHelper.loge(bl, instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            MdidSdkHelper.loge(bl, invocationTargetException);
        }
        MdidSdkHelper.logd(bl, "exception exit");
        return 1008615;
    }

    public static void logd(boolean bl, String string) {
        if (!bl) {
            return;
        }
        Log.d((String)TAG, (String)string);
    }

    public static void loge(boolean bl, Exception exception) {
        if (!bl) {
            return;
        }
        Log.e((String)TAG, (String)exception.getClass().getSimpleName(), (Throwable)exception);
    }
}

