/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.impl.TestCaseImpl;
import io.vertx.ext.unit.impl.TestSuiteReportImpl;
import io.vertx.ext.unit.report.TestSuiteReport;
import java.util.List;

public class TestSuiteRunner {
    private final String name;
    private final Handler<TestContext> before;
    private final Handler<TestContext> after;
    private final Handler<TestContext> beforeEach;
    private final Handler<TestContext> afterEach;
    private final List<TestCaseImpl> tests;
    private Vertx vertx;
    private Handler<TestSuiteReport> handler;
    private long timeout;
    private Boolean useEventLoop;

    public TestSuiteRunner(String name, Handler<TestContext> before, Handler<TestContext> after, Handler<TestContext> beforeEach, Handler<TestContext> afterEach, List<TestCaseImpl> tests) {
        this.name = name;
        this.timeout = 0L;
        this.before = before;
        this.after = after;
        this.beforeEach = beforeEach;
        this.afterEach = afterEach;
        this.tests = tests;
    }

    public List<TestCaseImpl> getTests() {
        return this.tests;
    }

    public Boolean isUseEventLoop() {
        return this.useEventLoop;
    }

    public TestSuiteRunner setUseEventLoop(Boolean useEventLoop) {
        this.useEventLoop = useEventLoop;
        return this;
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public TestSuiteRunner setVertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TestSuiteRunner setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public Handler<TestSuiteReport> getReporter() {
        return this.handler;
    }

    public TestSuiteRunner setReporter(Handler<TestSuiteReport> reporter) {
        this.handler = reporter;
        return this;
    }

    public void run() {
        TestSuiteReportImpl runner = new TestSuiteReportImpl(this.name, this.timeout, this.before, this.after, this.beforeEach, this.afterEach, this.tests.toArray(new TestCaseImpl[this.tests.size()]));
        this.handler.handle((Object)runner);
        if (this.vertx != null) {
            runner.run(this.vertx, this.useEventLoop);
        } else {
            runner.run(this.useEventLoop);
        }
    }
}

