/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.unit.junit;

import io.vertx.ext.unit.junit.VertxUnitRunner;
import java.util.concurrent.TimeUnit;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class Timeout
implements TestRule {
    private final long value;

    public static Timeout millis(long millis) {
        return new Timeout(millis, TimeUnit.MILLISECONDS);
    }

    public static Timeout seconds(long seconds) {
        return new Timeout(seconds, TimeUnit.SECONDS);
    }

    public Timeout(long value, TimeUnit unit) {
        this.value = unit.toMillis(value);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                VertxUnitRunner.pushTimeout(Timeout.this.value);
                try {
                    base.evaluate();
                }
                finally {
                    VertxUnitRunner.popTimeout();
                }
            }
        };
    }
}

