/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.dsl;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import io.spring.gradle.dependencymanagement.dsl.DependenciesHandler;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementConfigurer;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementHandler;
import io.spring.gradle.dependencymanagement.dsl.GeneratedPomCustomizationHandler;
import io.spring.gradle.dependencymanagement.dsl.ImportsHandler;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementConfigurationContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementSettings;
import io.spring.gradle.dependencymanagement.internal.StandardPomDependencyManagementConfigurer;
import io.spring.gradle.dependencymanagement.internal.dsl.ClosureBackedAction;
import io.spring.gradle.dependencymanagement.internal.dsl.CompoundDependencyManagementConfigurer;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardDependencyManagementHandler;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardGeneratedPomCustomizationHandler;
import io.spring.gradle.dependencymanagement.internal.maven.MavenPomResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolutionStrategy;

public class StandardDependencyManagementExtension
extends GroovyObjectSupport
implements DependencyManagementExtension {
    private final DependencyManagementContainer dependencyManagementContainer;
    private final Project project;
    private final DependencyManagementConfigurationContainer configurationContainer;
    private final DependencyManagementSettings dependencyManagementSettings;

    public StandardDependencyManagementExtension(DependencyManagementContainer dependencyManagementContainer, DependencyManagementConfigurationContainer configurationContainer, Project project, DependencyManagementSettings dependencyManagementSettings) {
        this.dependencyManagementContainer = dependencyManagementContainer;
        this.configurationContainer = configurationContainer;
        this.project = project;
        this.dependencyManagementSettings = dependencyManagementSettings;
    }

    @Override
    public void imports(Closure closure) {
        new StandardDependencyManagementHandler(this.dependencyManagementContainer).imports(closure);
    }

    @Override
    public void imports(Action<ImportsHandler> action) {
        new StandardDependencyManagementHandler(this.dependencyManagementContainer).imports(action);
    }

    @Override
    public void dependencies(Closure closure) {
        new StandardDependencyManagementHandler(this.dependencyManagementContainer).dependencies(closure);
    }

    @Override
    public void dependencies(Action<DependenciesHandler> action) {
        new StandardDependencyManagementHandler(this.dependencyManagementContainer).dependencies(action);
    }

    @Override
    public Map<String, String> getImportedProperties() {
        return this.dependencyManagementContainer.importedPropertiesForConfiguration(null);
    }

    @Override
    public Map<String, String> getManagedVersions() {
        return this.dependencyManagementContainer.getManagedVersionsForConfiguration(null);
    }

    @Override
    public Map<String, String> getManagedVersionsForConfiguration(Configuration configuration) {
        return this.dependencyManagementContainer.getManagedVersionsForConfiguration(configuration, false);
    }

    @Override
    public Map<String, String> getManagedVersionsForConfigurationHierarchy(Configuration configuration) {
        return this.dependencyManagementContainer.getManagedVersionsForConfiguration(configuration, true);
    }

    @Override
    public void resolutionStrategy(Closure closure) {
        this.resolutionStrategy(new ClosureBackedAction<ResolutionStrategy>(closure));
    }

    @Override
    public void resolutionStrategy(final Action<ResolutionStrategy> action) {
        this.configurationContainer.apply(new Action<Configuration>(){

            public void execute(Configuration configuration) {
                action.execute((Object)configuration.getResolutionStrategy());
            }
        });
    }

    @Override
    public void generatedPomCustomization(Closure closure) {
        this.generatedPomCustomization(new ClosureBackedAction<GeneratedPomCustomizationHandler>(closure));
    }

    @Override
    public void generatedPomCustomization(Action<GeneratedPomCustomizationHandler> action) {
        action.execute((Object)new StandardGeneratedPomCustomizationHandler(this.dependencyManagementSettings.getPomCustomizationSettings()));
    }

    @Override
    public StandardPomDependencyManagementConfigurer getPomConfigurer() {
        return new StandardPomDependencyManagementConfigurer(this.dependencyManagementContainer.getGlobalDependencyManagement(), this.dependencyManagementSettings.getPomCustomizationSettings(), new MavenPomResolver(this.project, this.configurationContainer), this.project);
    }

    public Object methodMissing(String name, Object args) {
        Closure closure;
        Object[] argsArray = (Object[])args;
        if ("configurations".equals(name)) {
            closure = (Closure)argsArray[argsArray.length - 1];
            closure.setDelegate((Object)new CompoundDependencyManagementConfigurer(this.extractConfigurers(argsArray)));
        } else {
            Configuration configuration = this.project.getConfigurations().getAt(name);
            closure = (Closure)argsArray[0];
            closure.setDelegate((Object)new StandardDependencyManagementHandler(this.dependencyManagementContainer, configuration));
        }
        closure.setResolveStrategy(3);
        return closure.call();
    }

    private List<DependencyManagementConfigurer> extractConfigurers(Object[] objects) {
        ArrayList<DependencyManagementConfigurer> configurers = new ArrayList<DependencyManagementConfigurer>();
        for (Object object : objects) {
            if (object instanceof DependencyManagementConfigurer) {
                configurers.add((DependencyManagementConfigurer)object);
                continue;
            }
            if (object instanceof Configuration) {
                configurers.add(this.handlerForConfiguration((Configuration)object));
                continue;
            }
            if (!(object instanceof CharSequence)) continue;
            configurers.add(this.handlerForConfiguration(object.toString()));
        }
        return configurers;
    }

    public Object propertyMissing(String name) {
        return this.handlerForConfiguration(name);
    }

    private DependencyManagementHandler handlerForConfiguration(String name) {
        return this.handlerForConfiguration(this.project.getConfigurations().getByName(name));
    }

    private DependencyManagementHandler handlerForConfiguration(Configuration configuration) {
        return new StandardDependencyManagementHandler(this.dependencyManagementContainer, configuration);
    }

    @Override
    public void setApplyMavenExclusions(boolean applyMavenExclusions) {
        this.dependencyManagementSettings.setApplyMavenExclusions(applyMavenExclusions);
    }

    @Override
    public void applyMavenExclusions(boolean applyMavenExclusions) {
        this.dependencyManagementSettings.setApplyMavenExclusions(applyMavenExclusions);
    }

    @Override
    public void setOverriddenByDependencies(boolean overriddenByDependencies) {
        this.dependencyManagementSettings.setOverriddenByDependencies(overriddenByDependencies);
    }

    @Override
    public void overriddenByDependencies(boolean overriddenByDependencies) {
        this.dependencyManagementSettings.setOverriddenByDependencies(overriddenByDependencies);
    }

    public DependencyManagementSettings.PomCustomizationSettings getPomCustomizationSettings() {
        return this.dependencyManagementSettings.getPomCustomizationSettings();
    }
}

