/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.lease;

import io.rsocket.exceptions.RejectedException;
import io.rsocket.lease.Lease;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class MissingLeaseException
extends RejectedException {
    private static final long serialVersionUID = -6169748673403858959L;

    public MissingLeaseException(Lease lease, String tag) {
        super(MissingLeaseException.leaseMessage(Objects.requireNonNull(lease), Objects.requireNonNull(tag)));
    }

    public MissingLeaseException(String tag) {
        super(MissingLeaseException.leaseMessage(null, Objects.requireNonNull(tag)));
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    static String leaseMessage(@Nullable Lease lease, String tag) {
        if (lease == null) {
            return String.format("[%s] Missing leases", tag);
        }
        if (lease.isEmpty()) {
            return String.format("[%s] Lease was not received yet", tag);
        }
        boolean expired = lease.isExpired();
        int allowedRequests = lease.getAllowedRequests();
        return String.format("[%s] Missing leases. Expired: %b, allowedRequests: %d", tag, expired, allowedRequests);
    }
}

