/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.ReassemblyUtils;
import io.rsocket.core.RequesterResponderSupport;
import io.rsocket.core.ResponderFrameHandler;
import io.rsocket.core.SendUtils;
import io.rsocket.core.StateUtils;
import io.rsocket.exceptions.CanceledException;
import io.rsocket.frame.CancelFrameCodec;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestNFrameCodec;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.plugins.RequestInterceptor;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class RequestChannelResponderSubscriber
extends Flux<Payload>
implements ResponderFrameHandler,
Subscription,
CoreSubscriber<Payload> {
    static final Logger logger = LoggerFactory.getLogger(RequestChannelResponderSubscriber.class);
    final int streamId;
    final ByteBufAllocator allocator;
    final PayloadDecoder payloadDecoder;
    final int mtu;
    final int maxFrameLength;
    final int maxInboundPayloadSize;
    final RequesterResponderSupport requesterResponderSupport;
    final DuplexConnection connection;
    final long firstRequest;
    @Nullable
    final RequestInterceptor requestInterceptor;
    final RSocket handler;
    volatile long state;
    static final AtomicLongFieldUpdater<RequestChannelResponderSubscriber> STATE = AtomicLongFieldUpdater.newUpdater(RequestChannelResponderSubscriber.class, "state");
    Payload firstPayload;
    Subscription outboundSubscription;
    CoreSubscriber<? super Payload> inboundSubscriber;
    CompositeByteBuf frames;
    volatile Throwable inboundError;
    static final AtomicReferenceFieldUpdater<RequestChannelResponderSubscriber, Throwable> INBOUND_ERROR = AtomicReferenceFieldUpdater.newUpdater(RequestChannelResponderSubscriber.class, Throwable.class, "inboundError");
    boolean inboundDone;
    boolean outboundDone;

    public RequestChannelResponderSubscriber(int streamId, long firstRequestN, ByteBuf firstFrame, RequesterResponderSupport requesterResponderSupport, RSocket handler) {
        this.streamId = streamId;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.payloadDecoder = requesterResponderSupport.getPayloadDecoder();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
        this.handler = handler;
        this.firstRequest = firstRequestN;
        this.frames = ReassemblyUtils.addFollowingFrame(this.allocator.compositeBuffer(), firstFrame, true, this.maxInboundPayloadSize);
        STATE.lazySet(this, 0x200000000L);
    }

    public RequestChannelResponderSubscriber(int streamId, long firstRequestN, Payload firstPayload, RequesterResponderSupport requesterResponderSupport) {
        this.streamId = streamId;
        this.allocator = requesterResponderSupport.getAllocator();
        this.mtu = requesterResponderSupport.getMtu();
        this.maxFrameLength = requesterResponderSupport.getMaxFrameLength();
        this.maxInboundPayloadSize = requesterResponderSupport.getMaxInboundPayloadSize();
        this.requesterResponderSupport = requesterResponderSupport;
        this.connection = requesterResponderSupport.getDuplexConnection();
        this.payloadDecoder = requesterResponderSupport.getPayloadDecoder();
        this.requestInterceptor = requesterResponderSupport.getRequestInterceptor();
        this.firstRequest = firstRequestN;
        this.firstPayload = firstPayload;
        this.handler = null;
        this.frames = null;
    }

    public void subscribe(CoreSubscriber<? super Payload> actual) {
        long previousState = StateUtils.markSubscribed(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            Throwable t = Exceptions.terminate(INBOUND_ERROR, (Object)this);
            if (t != Exceptions.TERMINATED) {
                Operators.error(actual, (Throwable)t);
            } else {
                Operators.error(actual, (Throwable)new CancellationException("RequestChannelSubscriber has already been terminated"));
            }
            return;
        }
        if (StateUtils.isSubscribed(previousState)) {
            Operators.error(actual, (Throwable)new IllegalStateException("RequestChannelSubscriber allows only one Subscriber"));
            return;
        }
        this.inboundSubscriber = actual;
        actual.onSubscribe((Subscription)this);
    }

    public void onSubscribe(Subscription outboundSubscription) {
        if (Operators.validate((Subscription)this.outboundSubscription, (Subscription)outboundSubscription)) {
            this.outboundSubscription = outboundSubscription;
            outboundSubscription.request(this.firstRequest);
        }
    }

    public void request(long n) {
        if (!Operators.validate((long)n)) {
            return;
        }
        long previousState = StateUtils.addRequestN(STATE, this, n);
        if (StateUtils.isTerminated(previousState)) {
            Throwable inboundError = Exceptions.terminate(INBOUND_ERROR, (Object)this);
            if (inboundError == Exceptions.TERMINATED) {
                return;
            }
            if (inboundError != null || this.inboundDone) {
                CoreSubscriber<? super Payload> inboundSubscriber = this.inboundSubscriber;
                Payload firstPayload = this.firstPayload;
                if (firstPayload != null) {
                    this.firstPayload = null;
                    inboundSubscriber.onNext((Object)firstPayload);
                }
                if (inboundError != null) {
                    inboundSubscriber.onError(inboundError);
                } else {
                    inboundSubscriber.onComplete();
                }
            }
            return;
        }
        if (StateUtils.isInboundTerminated(previousState)) {
            if (!StateUtils.hasRequested(previousState) && !StateUtils.isFirstFrameSent(previousState) && this.inboundDone) {
                CoreSubscriber<? super Payload> inboundSubscriber = this.inboundSubscriber;
                Payload firstPayload = this.firstPayload;
                this.firstPayload = null;
                inboundSubscriber.onNext((Object)firstPayload);
                inboundSubscriber.onComplete();
                StateUtils.markFirstFrameSent(STATE, this);
            }
            return;
        }
        if (StateUtils.hasRequested(previousState)) {
            if (StateUtils.isFirstFrameSent(previousState) && !StateUtils.isMaxAllowedRequestN(StateUtils.extractRequestN(previousState))) {
                int streamId = this.streamId;
                ByteBuf requestNFrame = RequestNFrameCodec.encode(this.allocator, streamId, n);
                this.connection.sendFrame(streamId, requestNFrame);
            }
            return;
        }
        CoreSubscriber<? super Payload> inboundSubscriber = this.inboundSubscriber;
        Payload firstPayload = this.firstPayload;
        this.firstPayload = null;
        inboundSubscriber.onNext((Object)firstPayload);
        previousState = StateUtils.markFirstFrameSent(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            Throwable inboundError = Exceptions.terminate(INBOUND_ERROR, (Object)this);
            if (inboundError == Exceptions.TERMINATED) {
                return;
            }
            if (inboundError != null) {
                inboundSubscriber.onError(inboundError);
            } else if (this.inboundDone) {
                inboundSubscriber.onComplete();
            }
            return;
        }
        if (StateUtils.isInboundTerminated(previousState)) {
            if (this.inboundDone) {
                inboundSubscriber.onComplete();
            }
            return;
        }
        long requestN = StateUtils.extractRequestN(previousState);
        if (StateUtils.isMaxAllowedRequestN(requestN)) {
            int streamId = this.streamId;
            ByteBuf requestNFrame = RequestNFrameCodec.encode(this.allocator, streamId, requestN);
            this.connection.sendFrame(streamId, requestNFrame);
        } else {
            long firstRequestN = requestN - 1L;
            if (firstRequestN > 0L) {
                int streamId = this.streamId;
                ByteBuf requestNFrame = RequestNFrameCodec.encode(this.allocator, streamId, firstRequestN);
                this.connection.sendFrame(streamId, requestNFrame);
            }
        }
    }

    public void cancel() {
        RequestInterceptor interceptor;
        long previousState = StateUtils.markInboundTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState) || StateUtils.isInboundTerminated(previousState)) {
            return;
        }
        if (!StateUtils.isFirstFrameSent(previousState) && !StateUtils.hasRequested(previousState)) {
            Payload firstPayload = this.firstPayload;
            this.firstPayload = null;
            firstPayload.release();
        }
        int streamId = this.streamId;
        boolean isOutboundTerminated = StateUtils.isOutboundTerminated(previousState);
        if (isOutboundTerminated) {
            this.requesterResponderSupport.remove(streamId, this);
        }
        ByteBuf cancelFrame = CancelFrameCodec.encode(this.allocator, streamId);
        this.connection.sendFrame(streamId, cancelFrame);
        if (isOutboundTerminated && (interceptor = this.requestInterceptor) != null) {
            interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, null);
        }
    }

    @Override
    public final void handleCancel() {
        Subscription outboundSubscription = this.outboundSubscription;
        if (outboundSubscription == null) {
            StateUtils.lazyTerminate(STATE, this);
            this.requesterResponderSupport.remove(this.streamId, this);
            CompositeByteBuf frames = this.frames;
            if (frames != null) {
                this.frames = null;
                frames.release();
            } else {
                Payload firstPayload = this.firstPayload;
                this.firstPayload = null;
                firstPayload.release();
            }
            RequestInterceptor interceptor = this.requestInterceptor;
            if (interceptor != null) {
                interceptor.onCancel(this.streamId, FrameType.REQUEST_CHANNEL);
            }
            return;
        }
        long previousState = this.tryTerminate(true);
        if (StateUtils.isTerminated(previousState)) {
            return;
        }
        RequestInterceptor interceptor = this.requestInterceptor;
        if (interceptor != null) {
            interceptor.onCancel(this.streamId, FrameType.REQUEST_CHANNEL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long tryTerminate(boolean isFromInbound) {
        Throwable inboundError;
        Subscription outboundSubscription;
        Exceptions.addThrowable(INBOUND_ERROR, (Object)this, (Throwable)new CancellationException("Inbound has been canceled"));
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            return previousState;
        }
        this.requesterResponderSupport.remove(this.streamId, this);
        if (StateUtils.isReassembling(previousState)) {
            CompositeByteBuf frames = this.frames;
            this.frames = null;
            if (isFromInbound) {
                frames.release();
            } else {
                CompositeByteBuf compositeByteBuf = frames;
                synchronized (compositeByteBuf) {
                    frames.release();
                }
            }
        }
        if ((outboundSubscription = this.outboundSubscription) == null) {
            return previousState;
        }
        outboundSubscription.cancel();
        if (!StateUtils.isSubscribed(previousState)) {
            Payload firstPayload = this.firstPayload;
            this.firstPayload = null;
            firstPayload.release();
        } else if (StateUtils.isFirstFrameSent(previousState) && !StateUtils.isInboundTerminated(previousState) && (inboundError = Exceptions.terminate(INBOUND_ERROR, (Object)this)) != Exceptions.TERMINATED) {
            if (isFromInbound) {
                this.inboundDone = true;
                this.inboundSubscriber.onError(inboundError);
            } else {
                RequestChannelResponderSubscriber requestChannelResponderSubscriber = this;
                synchronized (requestChannelResponderSubscriber) {
                    this.inboundDone = true;
                    this.inboundSubscriber.onError(inboundError);
                }
            }
        }
        return previousState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handlePayload(Payload p) {
        RequestChannelResponderSubscriber requestChannelResponderSubscriber = this;
        synchronized (requestChannelResponderSubscriber) {
            if (this.inboundDone) {
                p.release();
                return;
            }
            this.inboundSubscriber.onNext((Object)p);
        }
    }

    @Override
    public final void handleError(Throwable t) {
        Throwable inboundError;
        if (this.inboundDone) {
            Operators.onErrorDropped((Throwable)t, (Context)this.inboundSubscriber.currentContext());
            return;
        }
        this.inboundDone = true;
        boolean wasThrowableAdded = Exceptions.addThrowable(INBOUND_ERROR, (Object)this, (Throwable)t);
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            if (!wasThrowableAdded) {
                Operators.onErrorDropped((Throwable)t, (Context)this.inboundSubscriber.currentContext());
            }
            return;
        }
        this.requesterResponderSupport.remove(this.streamId, this);
        if (StateUtils.isReassembling(previousState)) {
            CompositeByteBuf frames = this.frames;
            this.frames = null;
            frames.release();
        }
        if (!StateUtils.isSubscribed(previousState)) {
            Payload firstPayload = this.firstPayload;
            this.firstPayload = null;
            firstPayload.release();
        } else if (StateUtils.isFirstFrameSent(previousState) && !StateUtils.isInboundTerminated(previousState) && (inboundError = Exceptions.terminate(INBOUND_ERROR, (Object)this)) != Exceptions.TERMINATED) {
            this.inboundSubscriber.onError(inboundError);
        }
        this.outboundSubscription.cancel();
        RequestInterceptor interceptor = this.requestInterceptor;
        if (interceptor != null) {
            interceptor.onTerminate(this.streamId, FrameType.REQUEST_CHANNEL, t);
        }
    }

    @Override
    public void handleComplete() {
        RequestInterceptor interceptor;
        if (this.inboundDone) {
            return;
        }
        this.inboundDone = true;
        long previousState = StateUtils.markInboundTerminated(STATE, this);
        boolean isOutboundTerminated = StateUtils.isOutboundTerminated(previousState);
        if (isOutboundTerminated) {
            this.requesterResponderSupport.remove(this.streamId, this);
        }
        if (StateUtils.isFirstFrameSent(previousState)) {
            this.inboundSubscriber.onComplete();
        }
        if (isOutboundTerminated && (interceptor = this.requestInterceptor) != null) {
            interceptor.onTerminate(this.streamId, FrameType.REQUEST_CHANNEL, null);
        }
    }

    @Override
    public void handleNext(ByteBuf frame, boolean hasFollows, boolean isLastPayload) {
        long previousState;
        long state = this.state;
        if (StateUtils.isTerminated(state)) {
            return;
        }
        if (!hasFollows && !StateUtils.isReassembling(state)) {
            Payload payload;
            try {
                payload = (Payload)this.payloadDecoder.apply(frame);
            }
            catch (Throwable t) {
                long previousState2 = this.tryTerminate(true);
                if (StateUtils.isTerminated(previousState2)) {
                    Operators.onErrorDropped((Throwable)t, (Context)this.inboundSubscriber.currentContext());
                    return;
                }
                if (StateUtils.isOutboundTerminated(previousState2)) {
                    RequestInterceptor interceptor = this.requestInterceptor;
                    if (interceptor != null) {
                        interceptor.onTerminate(this.streamId, FrameType.REQUEST_CHANNEL, t);
                    }
                    Operators.onErrorDropped((Throwable)t, (Context)this.inboundSubscriber.currentContext());
                    return;
                }
                this.outboundDone = true;
                int streamId = this.streamId;
                ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, new CanceledException(t.getMessage()));
                this.connection.sendFrame(streamId, errorFrame);
                RequestInterceptor interceptor = this.requestInterceptor;
                if (interceptor != null) {
                    interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, t);
                }
                return;
            }
            this.handlePayload(payload);
            if (isLastPayload) {
                this.handleComplete();
            }
            return;
        }
        CompositeByteBuf frames = this.frames;
        if (frames == null) {
            this.frames = frames = ReassemblyUtils.addFollowingFrame(this.allocator.compositeBuffer(), frame, hasFollows, this.maxInboundPayloadSize);
            previousState = StateUtils.markReassembling(STATE, this);
            if (StateUtils.isTerminated(previousState)) {
                this.frames = null;
                frames.release();
                return;
            }
        } else {
            try {
                frames = ReassemblyUtils.addFollowingFrame(frames, frame, hasFollows, this.maxInboundPayloadSize);
            }
            catch (IllegalStateException e) {
                if (StateUtils.isTerminated(this.state)) {
                    return;
                }
                long previousState3 = this.tryTerminate(true);
                if (StateUtils.isTerminated(previousState3)) {
                    Operators.onErrorDropped((Throwable)e, (Context)this.inboundSubscriber.currentContext());
                    return;
                }
                if (StateUtils.isOutboundTerminated(previousState3)) {
                    RequestInterceptor interceptor = this.requestInterceptor;
                    if (interceptor != null) {
                        interceptor.onTerminate(this.streamId, FrameType.REQUEST_CHANNEL, e);
                    }
                    Operators.onErrorDropped((Throwable)e, (Context)this.inboundSubscriber.currentContext());
                    return;
                }
                this.outboundDone = true;
                int streamId = this.streamId;
                ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, new CanceledException("Failed to reassemble payload. Cause: " + e.getMessage()));
                this.connection.sendFrame(streamId, errorFrame);
                RequestInterceptor interceptor = this.requestInterceptor;
                if (interceptor != null) {
                    interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, e);
                }
                return;
            }
        }
        if (!hasFollows) {
            Payload payload;
            previousState = StateUtils.markReassembled(STATE, this);
            if (StateUtils.isTerminated(previousState)) {
                return;
            }
            this.frames = null;
            try {
                payload = (Payload)this.payloadDecoder.apply(frames);
                frames.release();
            }
            catch (Throwable t) {
                ReferenceCountUtil.safeRelease((Object)frames);
                previousState = this.tryTerminate(true);
                if (StateUtils.isTerminated(previousState)) {
                    Operators.onErrorDropped((Throwable)t, (Context)this.inboundSubscriber.currentContext());
                    return;
                }
                if (StateUtils.isOutboundTerminated(previousState)) {
                    RequestInterceptor interceptor = this.requestInterceptor;
                    if (interceptor != null) {
                        interceptor.onTerminate(this.streamId, FrameType.REQUEST_CHANNEL, t);
                    }
                    Operators.onErrorDropped((Throwable)t, (Context)this.inboundSubscriber.currentContext());
                    return;
                }
                int streamId = this.streamId;
                ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, new CanceledException("Failed to reassemble payload. Cause: " + t.getMessage()));
                this.connection.sendFrame(streamId, errorFrame);
                RequestInterceptor interceptor = this.requestInterceptor;
                if (interceptor != null) {
                    interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, t);
                }
                return;
            }
            if (this.outboundSubscription == null) {
                this.firstPayload = payload;
                Flux<Payload> source = this.handler.requestChannel((Publisher<Payload>)this);
                source.subscribe((CoreSubscriber)this);
            } else {
                this.handlePayload(payload);
            }
            if (isLastPayload) {
                this.handleComplete();
            }
        }
    }

    public void onNext(Payload p) {
        block14: {
            if (this.outboundDone) {
                ReferenceCountUtil.safeRelease((Object)p);
                return;
            }
            int streamId = this.streamId;
            DuplexConnection connection = this.connection;
            ByteBufAllocator allocator = this.allocator;
            int mtu = this.mtu;
            try {
                if (!PayloadValidationUtils.isValid(mtu, this.maxFrameLength, p, false)) {
                    p.release();
                    long previousState = this.tryTerminate(false);
                    if (StateUtils.isTerminated(previousState)) {
                        Operators.onErrorDropped((Throwable)new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength)), (Context)this.inboundSubscriber.currentContext());
                        return;
                    }
                    if (StateUtils.isOutboundTerminated(previousState)) {
                        IllegalArgumentException e = new IllegalArgumentException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
                        RequestInterceptor interceptor = this.requestInterceptor;
                        if (interceptor != null) {
                            interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, e);
                        }
                        Operators.onErrorDropped((Throwable)e, (Context)this.inboundSubscriber.currentContext());
                        return;
                    }
                    CanceledException e = new CanceledException(String.format("The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.", this.maxFrameLength));
                    ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, e);
                    connection.sendFrame(streamId, errorFrame);
                    RequestInterceptor interceptor = this.requestInterceptor;
                    if (interceptor != null) {
                        interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, e);
                    }
                    return;
                }
            }
            catch (IllegalReferenceCountException e) {
                long previousState = this.tryTerminate(false);
                if (StateUtils.isTerminated(previousState)) {
                    Operators.onErrorDropped((Throwable)e, (Context)this.inboundSubscriber.currentContext());
                    return;
                }
                if (StateUtils.isOutboundTerminated(previousState)) {
                    RequestInterceptor interceptor = this.requestInterceptor;
                    if (interceptor != null) {
                        interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, e);
                    }
                    Operators.onErrorDropped((Throwable)e, (Context)this.inboundSubscriber.currentContext());
                    return;
                }
                ByteBuf errorFrame = ErrorFrameCodec.encode(allocator, streamId, new CanceledException("Failed to validate payload. Cause:" + e.getMessage()));
                connection.sendFrame(streamId, errorFrame);
                RequestInterceptor interceptor = this.requestInterceptor;
                if (interceptor != null) {
                    interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, e);
                }
                return;
            }
            try {
                SendUtils.sendReleasingPayload(streamId, FrameType.NEXT, mtu, p, connection, allocator, false);
            }
            catch (Throwable t) {
                long previousState = this.tryTerminate(false);
                RequestInterceptor interceptor = this.requestInterceptor;
                if (interceptor == null || StateUtils.isTerminated(previousState)) break block14;
                interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        Throwable inboundError;
        Object object;
        if (this.outboundDone) {
            Operators.onErrorDropped((Throwable)t, (Context)this.inboundSubscriber.currentContext());
            return;
        }
        boolean wasThrowableAdded = Exceptions.addThrowable(INBOUND_ERROR, (Object)this, (Throwable)new CancellationException("Outbound has terminated with an error"));
        this.outboundDone = true;
        long previousState = StateUtils.markTerminated(STATE, this);
        if (StateUtils.isTerminated(previousState)) {
            Operators.onErrorDropped((Throwable)t, (Context)this.inboundSubscriber.currentContext());
            return;
        }
        int streamId = this.streamId;
        this.requesterResponderSupport.remove(streamId, this);
        if (StateUtils.isReassembling(previousState)) {
            CompositeByteBuf frames = this.frames;
            this.frames = null;
            object = frames;
            synchronized (object) {
                frames.release();
            }
        }
        if (!StateUtils.isSubscribed(previousState)) {
            Payload firstPayload = this.firstPayload;
            this.firstPayload = null;
            firstPayload.release();
        } else if (wasThrowableAdded && StateUtils.isFirstFrameSent(previousState) && !StateUtils.isInboundTerminated(previousState) && (inboundError = Exceptions.terminate(INBOUND_ERROR, (Object)this)) != Exceptions.TERMINATED) {
            object = this;
            synchronized (object) {
                this.inboundDone = true;
                this.inboundSubscriber.onError(inboundError);
            }
        }
        ByteBuf errorFrame = ErrorFrameCodec.encode(this.allocator, streamId, t);
        this.connection.sendFrame(streamId, errorFrame);
        RequestInterceptor interceptor = this.requestInterceptor;
        if (interceptor != null) {
            interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, t);
        }
    }

    public void onComplete() {
        RequestInterceptor interceptor;
        if (this.outboundDone) {
            return;
        }
        this.outboundDone = true;
        long previousState = StateUtils.markOutboundTerminated(STATE, this, false);
        if (StateUtils.isTerminated(previousState)) {
            return;
        }
        int streamId = this.streamId;
        boolean isInboundTerminated = StateUtils.isInboundTerminated(previousState);
        if (isInboundTerminated) {
            this.requesterResponderSupport.remove(streamId, this);
        }
        ByteBuf completeFrame = PayloadFrameCodec.encodeComplete(this.allocator, streamId);
        this.connection.sendFrame(streamId, completeFrame);
        if (isInboundTerminated && (interceptor = this.requestInterceptor) != null) {
            interceptor.onTerminate(streamId, FrameType.REQUEST_CHANNEL, null);
        }
    }

    @Override
    public final void handleRequestN(long n) {
        this.outboundSubscription.request(n);
    }

    public Context currentContext() {
        return SendUtils.DISCARD_CONTEXT;
    }
}

