/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer.build;

import io.realm.transformer.BytecodeModifier;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.build.BuildTemplate;
import io.realm.transformer.build.FullBuild;
import io.realm.transformer.ext.CtClassExtKt;
import java.io.File;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.CtClass;
import javassist.CtField;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/realm/transformer/build/FullBuild;", "Lio/realm/transformer/build/BuildTemplate;", "metadata", "Lio/realm/transformer/ProjectMetaData;", "inputJars", "", "Lorg/gradle/api/file/RegularFile;", "output", "Ljava/nio/file/FileSystem;", "inputDirectories", "Lorg/gradle/api/file/ConfigurableFileCollection;", "(Lio/realm/transformer/ProjectMetaData;Ljava/util/List;Ljava/nio/file/FileSystem;Lorg/gradle/api/file/ConfigurableFileCollection;)V", "allModelClasses", "Ljavassist/CtClass;", "filterForModelClasses", "", "classNames", "", "", "extraClassNames", "findModelClasses", "merge", "set1", "set2", "prepareOutputClasses", "transformDirectAccessToModelFields", "shouldCategorize", "", "Ljava/io/File;", "realm-transformer"})
public final class FullBuild
extends BuildTemplate {
    private List<? extends CtClass> allModelClasses;

    public FullBuild(@NotNull ProjectMetaData metadata, @NotNull List<? extends RegularFile> inputJars, @NotNull FileSystem output, @NotNull ConfigurableFileCollection inputDirectories) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(inputJars, (String)"inputJars");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inputDirectories, (String)"inputDirectories");
        super(metadata, inputJars, output, inputDirectories);
    }

    @Override
    public void prepareOutputClasses() {
        this.setOutputClassNames(this.categorizeClassNames());
        RealmTransformerKt.getLogger().debug("Full build. Number of files being processed: " + this.getOutputClassNames().size() + ".");
    }

    @Override
    @NotNull
    protected List<CtClass> findModelClasses(@NotNull Set<String> classNames) {
        CtClass clazz;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
        CtClass ctClass = this.getClassPool().get("io.realm.internal.RealmObjectProxy");
        Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"classPool.get(\"io.realm.\u2026ternal.RealmObjectProxy\")");
        CtClass realmObjectProxyInterface = ctClass;
        Iterable $this$filter$iv = classNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it, (String)"RealmProxy", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getClassPool().getCtClass(it));
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            clazz = (CtClass)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"clazz");
            if (!CtClassExtKt.safeSubtypeOf(clazz, realmObjectProxyInterface)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            clazz = (CtClass)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSuperclass());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean shouldCategorize(@NotNull File $this$shouldCategorize) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldCategorize, (String)"<this>");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void filterForModelClasses(@NotNull Set<String> classNames, @NotNull Set<String> extraClassNames) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(classNames, (String)"classNames");
        Intrinsics.checkNotNullParameter(extraClassNames, (String)"extraClassNames");
        Set<String> allClassNames = this.merge(classNames, extraClassNames);
        this.allModelClasses = this.findModelClasses(allClassNames);
        List<? extends CtClass> list = this.allModelClasses;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"allModelClasses");
            list = null;
        }
        Iterable iterable = list;
        FullBuild fullBuild = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CtClass it = (CtClass)element$iv$iv;
            boolean bl = false;
            if (!this.getOutputClassNames().contains(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fullBuild.setOutputModelClasses((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void transformDirectAccessToModelFields() {
        void $this$flatMapTo$iv$iv;
        List<? extends CtClass> list = this.allModelClasses;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"allModelClasses");
            list = null;
        }
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            CtClass ctClass = (CtClass)element$iv$iv;
            boolean bl = false;
            CtField[] ctFieldArray = ctClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)ctFieldArray, (String)"ctClass.declaredFields");
            Object[] $this$filter$iv = ctFieldArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv2 : $this$filterTo$iv$iv) {
                CtField ctField = (CtField)element$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)ctField, (String)"ctField");
                if (!BytecodeModifier.Companion.isModelField(ctField)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allManagedFields = (List)destination$iv$iv;
        RealmTransformerKt.getLogger().debug("Managed Fields: " + CollectionsKt.joinToString$default((Iterable)allManagedFields, (CharSequence)",", null, null, (int)0, null, (Function1)transformDirectAccessToModelFields.1.INSTANCE, (int)30, null));
        Iterable $this$forEach$iv = this.getOutputClassNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            RealmTransformerKt.getLogger().debug("Modifying accessors in class: " + it);
            try {
                CtClass ctClass;
                Intrinsics.checkNotNullExpressionValue((Object)this.getClassPool().getCtClass(it), (String)"classPool.getCtClass(it)");
                if (ctClass.isFrozen()) {
                    ctClass.defrost();
                }
                BytecodeModifier.Companion.useRealmAccessors(this.getClassPool(), ctClass, allManagedFields);
                this.getProcessedClasses().put(it, ctClass);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to transform " + it + ".", e);
            }
        }
    }

    private final Set<String> merge(Set<String> set1, Set<String> set2) {
        Set merged = new HashSet();
        merged.addAll((Collection)set1);
        merged.addAll((Collection)set2);
        return merged;
    }
}

