/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer.build;

import io.realm.transformer.BytecodeModifier;
import io.realm.transformer.ManagedClassPool;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.build.BuildTemplate;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010(\u001a\u00020)2\u0006\u0010\f\u001a\u00020*H\u0002J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010,\u001a\u00020\nH\u0002J\u0006\u0010-\u001a\u00020)J\u0006\u0010.\u001a\u00020)J$\u0010/\u001a\u00020)2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H$J\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H$J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020)J\b\u00105\u001a\u00020)H&J\u000e\u00106\u001a\u00020)2\u0006\u0010,\u001a\u00020\nJ\b\u00107\u001a\u00020)H&J\u0006\u00108\u001a\u00020)J\u001c\u00109\u001a\u00020)*\u00020\b2\u0006\u0010:\u001a\u00020\u00182\u0006\u0010;\u001a\u00020<H\u0002J\u0014\u0010=\u001a\u00020\u0018*\u00020>2\u0006\u0010?\u001a\u00020\u0018H\u0004J\f\u0010@\u001a\u000203*\u00020>H&R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0005X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001e0%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006A"}, d2={"Lio/realm/transformer/build/BuildTemplate;", "", "metadata", "Lio/realm/transformer/ProjectMetaData;", "allJars", "", "Lorg/gradle/api/file/RegularFile;", "output", "Ljava/nio/file/FileSystem;", "inputs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "(Lio/realm/transformer/ProjectMetaData;Ljava/util/List;Ljava/nio/file/FileSystem;Lorg/gradle/api/file/ConfigurableFileCollection;)V", "classPool", "Lio/realm/transformer/ManagedClassPool;", "getClassPool", "()Lio/realm/transformer/ManagedClassPool;", "setClassPool", "(Lio/realm/transformer/ManagedClassPool;)V", "getInputs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "getOutput", "()Ljava/nio/file/FileSystem;", "outputClassNames", "", "", "getOutputClassNames", "()Ljava/util/Set;", "setOutputClassNames", "(Ljava/util/Set;)V", "outputModelClasses", "Ljavassist/CtClass;", "getOutputModelClasses", "()Ljava/util/List;", "setOutputModelClasses", "(Ljava/util/List;)V", "outputReferencedClassNames", "processedClasses", "", "getProcessedClasses", "()Ljava/util/Map;", "addBootClassesToClassPool", "", "Ljavassist/ClassPool;", "categorizeClassNames", "referencedInputs", "copyProcessedClasses", "copyResourceFiles", "filterForModelClasses", "findModelClasses", "classNames", "hasNoOutput", "", "markMediatorsAsTransformed", "prepareOutputClasses", "prepareReferencedClasses", "transformDirectAccessToModelFields", "transformModelClasses", "addEntry", "entryPath", "input", "Ljava/io/InputStream;", "categorize", "Ljava/io/File;", "dirPath", "shouldCategorize", "realm-transformer"})
public abstract class BuildTemplate {
    @NotNull
    private final ProjectMetaData metadata;
    @NotNull
    private final List<RegularFile> allJars;
    @NotNull
    private final FileSystem output;
    @NotNull
    private final ConfigurableFileCollection inputs;
    protected ManagedClassPool classPool;
    protected Set<String> outputClassNames;
    private Set<String> outputReferencedClassNames;
    protected List<? extends CtClass> outputModelClasses;
    @NotNull
    private final Map<String, CtClass> processedClasses;

    public BuildTemplate(@NotNull ProjectMetaData metadata, @NotNull List<? extends RegularFile> allJars, @NotNull FileSystem output, @NotNull ConfigurableFileCollection inputs) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(allJars, (String)"allJars");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inputs, (String)"inputs");
        this.metadata = metadata;
        this.allJars = allJars;
        this.output = output;
        this.inputs = inputs;
        this.processedClasses = new LinkedHashMap();
    }

    @NotNull
    protected final FileSystem getOutput() {
        return this.output;
    }

    @NotNull
    public final ConfigurableFileCollection getInputs() {
        return this.inputs;
    }

    @NotNull
    protected final ManagedClassPool getClassPool() {
        ManagedClassPool managedClassPool = this.classPool;
        if (managedClassPool != null) {
            return managedClassPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
        return null;
    }

    protected final void setClassPool(@NotNull ManagedClassPool managedClassPool) {
        Intrinsics.checkNotNullParameter((Object)managedClassPool, (String)"<set-?>");
        this.classPool = managedClassPool;
    }

    @NotNull
    protected final Set<String> getOutputClassNames() {
        Set<String> set = this.outputClassNames;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"outputClassNames");
        return null;
    }

    protected final void setOutputClassNames(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.outputClassNames = set;
    }

    @NotNull
    protected final List<CtClass> getOutputModelClasses() {
        List<CtClass> list = this.outputModelClasses;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"outputModelClasses");
        return null;
    }

    protected final void setOutputModelClasses(@NotNull List<? extends CtClass> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.outputModelClasses = list;
    }

    @NotNull
    protected final Map<String, CtClass> getProcessedClasses() {
        return this.processedClasses;
    }

    public abstract void prepareOutputClasses();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> categorizeClassNames() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = (Iterable)this.inputs;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String dirPath;
            File directory = (File)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)directory.getAbsolutePath(), (String)"directory.absolutePath");
            Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"directory");
            Sequence list$iv$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)directory, null, (int)1, null)), (Function1)categorizeClassNames.1.1.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
                final /* synthetic */ BuildTemplate this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    return this.this$0.shouldCategorize(file);
                }
            })), (Function1)categorizeClassNames.1.3.INSTANCE), (Function1)((Function1)new Function1<File, String>(this, dirPath){
                final /* synthetic */ BuildTemplate this$0;
                final /* synthetic */ String $dirPath;
                {
                    this.this$0 = $receiver;
                    this.$dirPath = $dirPath;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull File it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.categorize(it, this.$dirPath);
                }
            }));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Set<String> categorizeClassNames(ConfigurableFileCollection referencedInputs) {
        $this$flatMap$iv = (Iterable)referencedInputs;
        $i$f$flatMap = false;
        var4_4 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            file = (File)element$iv$iv;
            $i$a$-flatMap-BuildTemplate$categorizeClassNames$2 = false;
            var11_11 = new JarFile(file);
            var12_12 = null;
            try {
                jarFile = (JarFile)var11_11;
                $i$a$-use-BuildTemplate$categorizeClassNames$2$1 = false;
                v0 = jarFile.entries();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"jarFile.entries()");
                v1 = Collections.list(v0);
                Intrinsics.checkNotNullExpressionValue(v1, (String)"list(this)");
                var15_17 = v1;
                $i$f$filter = false;
                var17_19 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    jarEntry = (JarEntry)element$iv$iv;
                    $i$a$-filter-BuildTemplate$categorizeClassNames$2$1$1 = false;
                    if (jarEntry.isDirectory()) ** GOTO lbl-1000
                    v2 = jarEntry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"jarEntry.name");
                    if (StringsKt.endsWith$default((String)v2, (String)".class", (boolean)false, (int)2, null)) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    jarEntry = (JarEntry)item$iv$iv;
                    var24_26 = destination$iv$iv;
                    $i$a$-map-BuildTemplate$categorizeClassNames$2$1$2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)jarEntry.getName(), (String)"jarEntry.name");
                    v4 = path.substring(0, path.length() - ".class".length());
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    var24_26.add(StringsKt.replace$default((String)StringsKt.replace$default((String)v4, (char)'/', (char)'.', (boolean)false, (int)4, null), (char)'\\', (char)'.', (boolean)false, (int)4, null));
                }
                var13_13 = (List)destination$iv$iv;
            }
            catch (Throwable var13_14) {
                var12_12 = var13_14;
                throw var13_14;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var11_11, (Throwable)var12_12);
            }
            list$iv$iv = var13_13;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean hasNoOutput() {
        return this.getOutputClassNames().isEmpty();
    }

    public final void prepareReferencedClasses(@NotNull ConfigurableFileCollection referencedInputs) {
        Intrinsics.checkNotNullParameter((Object)referencedInputs, (String)"referencedInputs");
        this.outputReferencedClassNames = this.categorizeClassNames(referencedInputs);
        this.setClassPool(new ManagedClassPool(this.inputs, referencedInputs));
        this.addBootClassesToClassPool(this.getClassPool());
        RealmTransformerKt.getLogger().debug("ClassPool contains Realm classes: " + (this.getClassPool().getOrNull("io.realm.RealmList") != null));
        Set<String> set = this.getOutputClassNames();
        Set<String> set2 = this.outputReferencedClassNames;
        if (set2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputReferencedClassNames");
            set2 = null;
        }
        this.filterForModelClasses(set, set2);
    }

    protected abstract void filterForModelClasses(@NotNull Set<String> var1, @NotNull Set<String> var2);

    /*
     * WARNING - void declaration
     */
    public final void markMediatorsAsTransformed() {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        CtClass ctClass = this.getClassPool().get("io.realm.internal.RealmProxyMediator");
        Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"classPool.get(\"io.realm.\u2026rnal.RealmProxyMediator\")");
        CtClass baseProxyMediator = ctClass;
        Pattern pattern = Pattern.compile("^io\\.realm\\.[^.]+Mediator$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^io\\\\.realm\\\\.[^.]+Mediator$\")");
        Pattern mediatorPattern = pattern;
        Iterable iterable = this.getOutputClassNames();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!mediatorPattern.matcher(it).find()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getClassPool().getCtClass(it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            if (!it.getSuperclass().equals((Object)baseProxyMediator)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection proxyMediatorClasses = (List)destination$iv$iv;
        RealmTransformerKt.getLogger().debug("Proxy Mediator Classes: " + CollectionsKt.joinToString$default((Iterable)proxyMediatorClasses, (CharSequence)",", null, null, (int)0, null, (Function1)markMediatorsAsTransformed.1.INSTANCE, (int)30, null));
        Iterable $this$forEach$iv = proxyMediatorClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass it2 = (CtClass)element$iv;
            boolean bl = false;
            BytecodeModifier.Companion.overrideTransformedMarker(it2);
            Map<String, CtClass> map = this.processedClasses;
            String string = it2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            map.put(string, it2);
        }
    }

    public final void transformModelClasses() {
        Iterable $this$forEach$iv = this.getOutputModelClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass it = (CtClass)element$iv;
            boolean bl = false;
            RealmTransformerKt.getLogger().debug("Modify model class: " + it.getName());
            BytecodeModifier.Companion.addRealmAccessors(it);
            BytecodeModifier.Companion.addRealmProxyInterface(it, this.getClassPool());
            BytecodeModifier.Companion.callInjectObjectContextFromConstructors(it);
            Map<String, CtClass> map = this.processedClasses;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            map.put(string, it);
        }
    }

    public abstract void transformDirectAccessToModelFields();

    public final void copyProcessedClasses() {
        Map<String, CtClass> $this$forEach$iv = this.processedClasses;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, CtClass>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            byte[] byArray;
            Map.Entry<String, CtClass> element$iv;
            Map.Entry<String, CtClass> entry = element$iv = iterator.next();
            boolean bl = false;
            String fqName = entry.getKey();
            CtClass clazz = entry.getValue();
            String string = StringsKt.replace$default((String)fqName, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
            Intrinsics.checkNotNullExpressionValue((Object)clazz.toBytecode(), (String)"clazz.toBytecode()");
            this.addEntry(this.output, string, new ByteArrayInputStream(byArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void copyResourceFiles() {
        Object object;
        Iterable $this$forEach$iv = (Iterable)this.inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            File directory = (File)element$iv;
            boolean bl = false;
            String dirName = directory.getAbsolutePath() + File.separator;
            object = SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)directory, null, (int)1, null)), (Function1)copyResourceFiles.1.1.INSTANCE), (Function1)copyResourceFiles.1.2.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                File file = (File)element$iv2;
                boolean bl2 = false;
                String string = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                String pathWithoutPrefix = StringsKt.removePrefix((String)string, (CharSequence)dirName);
                String zipEntryPath = StringsKt.replace$default((String)pathWithoutPrefix, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                this.addEntry(this.output, zipEntryPath, new FileInputStream(file));
            }
        }
        $this$forEach$iv = this.allJars;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RegularFile file = (RegularFile)element$iv;
            boolean bl = false;
            Closeable closeable = new JarFile(file.getAsFile());
            object = null;
            try {
                void $this$forEach$iv3;
                Object element$iv2;
                JarFile jarFile = (JarFile)closeable;
                boolean bl3 = false;
                Enumeration<JarEntry> enumeration = jarFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile.entries()");
                ArrayList<JarEntry> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
                element$iv2 = arrayList;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    JarEntry jarEntry = (JarEntry)element$iv3;
                    boolean bl4 = false;
                    Closeable closeable2 = jarFile.getInputStream(jarEntry);
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable2;
                        boolean bl5 = false;
                        String string = jarEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarEntry.name");
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        this.addEntry(this.output, string, it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        this.getClassPool().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addEntry(FileSystem $this$addEntry, String entryPath, InputStream input) {
        Object object;
        Path path = $this$addEntry.getPath(entryPath, new String[0]);
        boolean bl = false;
        if (object != null) {
            object = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent");
            OpenOption[] it = object;
            boolean bl2 = false;
            Files.createDirectories((Path)it, new FileAttribute[0]);
        }
        object = new OpenOption[]{StandardOpenOption.CREATE};
        object = Files.newOutputStream(path, object);
        Throwable throwable = null;
        try {
            OutputStream stream = (OutputStream)object;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)stream, (int)0, (int)2, null);
            stream.close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final void addBootClassesToClassPool(ClassPool classPool) {
        try {
            Iterable $this$forEach$iv = this.metadata.getBootClassPath();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path;
                File it = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getAbsolutePath(), (String)"it.absolutePath");
                RealmTransformerKt.getLogger().debug("Add boot class " + path + " to class pool.");
                classPool.appendClassPath(path);
            }
        }
        catch (Exception e) {
            RealmTransformerKt.getLogger().debug("Cannot get bootClasspath caused by: ", (Throwable)e);
        }
    }

    @NotNull
    protected abstract List<CtClass> findModelClasses(@NotNull Set<String> var1);

    @NotNull
    protected final String categorize(@NotNull File $this$categorize, @NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)$this$categorize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        String string = $this$categorize.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"absolutePath");
        String string2 = string;
        int n = dirPath.length() + 1;
        int n2 = $this$categorize.getAbsolutePath().length() - ".class".length();
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return StringsKt.replace$default((String)string3, (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
    }

    public abstract boolean shouldCategorize(@NotNull File var1);
}

