/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.informer.cache.Store;
import io.kubernetes.client.util.common.Collections;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.MutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaFIFO<ApiType>
implements Store<Object> {
    private static final Logger log = LoggerFactory.getLogger(DeltaFIFO.class);
    private Function<ApiType, String> keyFunc;
    private Map<String, Deque<MutablePair<DeltaType, Object>>> items;
    private Deque<String> queue;
    private Store<ApiType> knownObjects;
    private boolean populated = false;
    private int initialPopulationCount;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Condition notEmpty;

    public DeltaFIFO(Function<ApiType, String> keyFunc, Store knownObjects) {
        this.keyFunc = keyFunc;
        this.knownObjects = knownObjects;
        this.items = new HashMap<String, Deque<MutablePair<DeltaType, Object>>>();
        this.queue = new LinkedList<String>();
        this.notEmpty = this.lock.writeLock().newCondition();
    }

    @Override
    public void add(Object obj) {
        this.lock.writeLock().lock();
        try {
            this.populated = true;
            this.queueActionLocked(DeltaType.Added, obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void update(Object obj) {
        this.lock.writeLock().lock();
        try {
            this.populated = true;
            this.queueActionLocked(DeltaType.Updated, obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void delete(Object obj) {
        String id = this.keyOf(obj);
        this.lock.writeLock().lock();
        try {
            this.populated = true;
            if (this.knownObjects == null ? !this.items.containsKey(id) : this.knownObjects.getByKey(id) == null && !this.items.containsKey(id)) {
                return;
            }
            this.queueActionLocked(DeltaType.Deleted, obj);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void replace(List list, String resourceVersion) {
        this.lock.writeLock().lock();
        try {
            void var5_9;
            HashSet<String> keys = new HashSet<String>();
            for (Object e : list) {
                String key = this.keyOf(e);
                keys.add(key);
                this.queueActionLocked(DeltaType.Sync, e);
            }
            if (this.knownObjects == null) {
                for (Map.Entry entry : this.items.entrySet()) {
                    if (keys.contains(entry.getKey())) continue;
                    Object deletedObj = null;
                    MutablePair delta = (MutablePair)((Deque)entry.getValue()).peekLast();
                    if (delta != null) {
                        deletedObj = delta.getRight();
                    }
                    this.queueActionLocked(DeltaType.Deleted, new DeletedFinalStateUnknown<Object>((String)entry.getKey(), deletedObj));
                }
                if (!this.populated) {
                    this.populated = true;
                    this.initialPopulationCount = list.size();
                }
                return;
            }
            List<String> knownKeys = this.knownObjects.listKeys();
            boolean bl = false;
            for (String knownKey : knownKeys) {
                if (keys.contains(knownKey)) continue;
                ApiType deletedObj = this.knownObjects.getByKey(knownKey);
                if (deletedObj == null) {
                    log.warn("Key {} does not exist in known objects store, placing DeleteFinalStateUnknown marker without object", (Object)knownKey);
                }
                ++var5_9;
                this.queueActionLocked(DeltaType.Deleted, new DeletedFinalStateUnknown<ApiType>(knownKey, deletedObj));
            }
            if (!this.populated) {
                this.populated = true;
                this.initialPopulationCount = list.size() + var5_9;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resync() {
        this.lock.writeLock().lock();
        try {
            if (this.knownObjects == null) {
                return;
            }
            List<String> keys = this.knownObjects.listKeys();
            for (String key : keys) {
                this.syncKeyLocked(key);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listKeys() {
        this.lock.readLock().lock();
        try {
            ArrayList<String> keyList = new ArrayList<String>(this.items.size());
            for (Map.Entry<String, Deque<MutablePair<DeltaType, Object>>> entry : this.items.entrySet()) {
                keyList.add(entry.getKey());
            }
            ArrayList<String> arrayList = keyList;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Object get(Object obj) {
        String key = this.keyOf(obj);
        return this.getByKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deque<MutablePair<DeltaType, Object>> getByKey(String key) {
        this.lock.readLock().lock();
        try {
            Deque<MutablePair<DeltaType, Object>> deltas = this.items.get(key);
            if (deltas != null) {
                LinkedList<MutablePair<DeltaType, Object>> linkedList = new LinkedList<MutablePair<DeltaType, Object>>(deltas);
                return linkedList;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> list() {
        this.lock.readLock().lock();
        ArrayList<Object> objects = new ArrayList<Object>();
        try {
            for (Map.Entry<String, Deque<MutablePair<DeltaType, Object>>> entry : this.items.entrySet()) {
                LinkedList copiedDeltas = new LinkedList(entry.getValue());
                objects.add(copiedDeltas);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deque<MutablePair<DeltaType, Object>> pop(Consumer<Deque<MutablePair<DeltaType, Object>>> func) throws InterruptedException {
        this.lock.writeLock().lock();
        try {
            String id;
            while (true) {
                if (this.queue.isEmpty()) {
                    this.notEmpty.await();
                    continue;
                }
                id = this.queue.removeFirst();
                if (this.initialPopulationCount > 0) {
                    --this.initialPopulationCount;
                }
                if (this.items.containsKey(id)) break;
            }
            Deque<MutablePair<DeltaType, Object>> deltas = this.items.get(id);
            this.items.remove(id);
            func.accept(deltas);
            Deque<MutablePair<DeltaType, Object>> deque = deltas;
            return deque;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean hasSynced() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.populated && this.initialPopulationCount == 0;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void queueActionLocked(DeltaType actionType, Object obj) {
        String id = this.keyOf(obj);
        if (actionType == DeltaType.Sync && this.willObjectBeDeletedLocked(id)) {
            return;
        }
        Deque<MutablePair<DeltaType, Object>> deltas = this.items.get(id);
        if (deltas == null) {
            LinkedList<MutablePair> deltaList = new LinkedList<MutablePair>();
            deltaList.add(new MutablePair((Object)actionType, obj));
            deltas = new LinkedList<MutablePair<DeltaType, Object>>(deltaList);
        } else {
            deltas.add((MutablePair<DeltaType, Object>)new MutablePair((Object)actionType, obj));
        }
        Deque<MutablePair<DeltaType, Object>> combinedDeltaList = this.combineDeltas((LinkedList)deltas);
        boolean exist = this.items.containsKey(id);
        if (combinedDeltaList != null && combinedDeltaList.size() > 0) {
            if (!exist) {
                this.queue.add(id);
            }
            this.items.put(id, new LinkedList<MutablePair<DeltaType, Object>>(combinedDeltaList));
            this.notEmpty.signalAll();
        } else {
            this.items.remove(id);
        }
    }

    private boolean willObjectBeDeletedLocked(String id) {
        if (!this.items.containsKey(id)) {
            return false;
        }
        Deque<MutablePair<DeltaType, Object>> deltas = this.items.get(id);
        return !Collections.isEmptyCollection(deltas) && ((DeltaType)((Object)deltas.peekLast().getLeft())).equals((Object)DeltaType.Deleted);
    }

    private String keyOf(Object obj) {
        Object innerObj = obj;
        if (obj instanceof Deque) {
            Deque deltas = (Deque)obj;
            if (deltas.size() == 0) {
                throw new NoSuchElementException("0 length Deltas object; can't get key");
            }
            innerObj = ((MutablePair)deltas.peekLast()).getRight();
        }
        if (innerObj instanceof DeletedFinalStateUnknown) {
            return ((DeletedFinalStateUnknown)innerObj).key;
        }
        return this.keyFunc.apply(innerObj);
    }

    private void syncKeyLocked(String key) {
        ApiType obj = this.knownObjects.getByKey(key);
        if (obj == null) {
            return;
        }
        String id = this.keyOf(obj);
        Deque<MutablePair<DeltaType, Object>> deltas = this.items.get(id);
        if (deltas != null && !Collections.isEmptyCollection(deltas)) {
            return;
        }
        this.queueActionLocked(DeltaType.Sync, obj);
    }

    private Deque<MutablePair<DeltaType, Object>> combineDeltas(LinkedList<MutablePair<DeltaType, Object>> deltas) {
        MutablePair<DeltaType, Object> d2;
        if (deltas.size() < 2) {
            return deltas;
        }
        int size = deltas.size();
        MutablePair<DeltaType, Object> d1 = deltas.peekLast();
        MutablePair<DeltaType, Object> out = this.isDuplicate(d1, d2 = deltas.get(size - 2));
        if (out != null) {
            LinkedList<MutablePair<DeltaType, Object>> newDeltas = new LinkedList<MutablePair<DeltaType, Object>>();
            newDeltas.addAll(deltas.subList(0, size - 2));
            newDeltas.add(out);
            return newDeltas;
        }
        return deltas;
    }

    private MutablePair<DeltaType, Object> isDuplicate(MutablePair<DeltaType, Object> d1, MutablePair<DeltaType, Object> d2) {
        MutablePair<DeltaType, Object> deletionDelta = this.isDeletionDup(d1, d2);
        if (deletionDelta != null) {
            return deletionDelta;
        }
        return null;
    }

    private MutablePair<DeltaType, Object> isDeletionDup(MutablePair<DeltaType, Object> d1, MutablePair<DeltaType, Object> d2) {
        if (!((DeltaType)((Object)d1.getLeft())).equals((Object)DeltaType.Deleted) || !((DeltaType)((Object)d2.getLeft())).equals((Object)DeltaType.Deleted)) {
            return null;
        }
        Object obj = d2.getRight();
        if (obj instanceof DeletedFinalStateUnknown) {
            return d1;
        }
        return d2;
    }

    Map<String, Deque<MutablePair<DeltaType, Object>>> getItems() {
        return this.items;
    }

    public static enum DeltaType {
        Added,
        Updated,
        Deleted,
        Sync;

    }

    public static final class DeletedFinalStateUnknown<ApiType> {
        private String key;
        private ApiType obj;

        DeletedFinalStateUnknown(String key, ApiType obj) {
            this.key = key;
            this.obj = obj;
        }

        String getKey() {
            return this.key;
        }

        public ApiType getObj() {
            return this.obj;
        }
    }
}

